/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.security.service;

import jakarta.annotation.PostConstruct;
import lombok.Generated;
import net.schembs.solutions.dms.security.model.SimplifiedBackendInfo;
import net.schembs.solutions.dms.security.model.SimplifiedRealmInfo;
import net.schembs.solutions.dms.security.service.BackendUrlProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.web.client.RestTemplate;

public class SecurityConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityConfigurationService.class);
    private final RestTemplate unsecuredBackendRestTemplate;
    private final BackendUrlProvider backendUrlProvider;
    private SimplifiedRealmInfo simplifiedRealmInfo;
    private boolean initialized;

    @PostConstruct
    public void init() {
        try {
            log.info("Loading security configuration from backend");
            SimplifiedBackendInfo backendInfo = (SimplifiedBackendInfo)this.unsecuredBackendRestTemplate.getForObject("/info", SimplifiedBackendInfo.class, new Object[0]);
            String authServerUrl = backendInfo.getAuthServerUrl();
            log.info("Security service is at: {}", (Object)authServerUrl);
            RestTemplate restTemplate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(authServerUrl).build();
            this.simplifiedRealmInfo = (SimplifiedRealmInfo)restTemplate.getForObject("/.well-known/openid-configuration", SimplifiedRealmInfo.class, new Object[0]);
            log.info("Token endpoint: {}", (Object)this.simplifiedRealmInfo.getTokenEndpoint());
            this.initialized = true;
        }
        catch (Exception e) {
            log.warn("Backend info is not available from {}: {}", (Object)this.backendUrlProvider.getBackendUrl(), (Object)e.getMessage());
        }
    }

    public String getAuthServerTokenEndpoint() {
        return this.simplifiedRealmInfo != null ? this.simplifiedRealmInfo.getTokenEndpoint() : null;
    }

    public String getAuthServerUserEndpoint() {
        return this.simplifiedRealmInfo != null ? this.simplifiedRealmInfo.getUserEndpoint() : null;
    }

    public String getAuthServerAdminEndpoint() {
        return this.simplifiedRealmInfo != null ? this.simplifiedRealmInfo.getAdminEndpoint() : null;
    }

    @Generated
    public SecurityConfigurationService(RestTemplate unsecuredBackendRestTemplate, BackendUrlProvider backendUrlProvider) {
        this.unsecuredBackendRestTemplate = unsecuredBackendRestTemplate;
        this.backendUrlProvider = backendUrlProvider;
    }

    @Generated
    public SimplifiedRealmInfo getSimplifiedRealmInfo() {
        return this.simplifiedRealmInfo;
    }

    @Generated
    public boolean isInitialized() {
        return this.initialized;
    }
}

