/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.security.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.schembs.solutions.dms.security.config.AuthConfig;
import net.schembs.solutions.dms.security.exception.LoginFailedException;
import net.schembs.solutions.dms.security.exception.TokenRefreshFailedException;
import net.schembs.solutions.dms.security.jwt.Jwt;
import net.schembs.solutions.dms.security.jwt.JwtDecoder;
import net.schembs.solutions.dms.security.model.DmsPermission;
import net.schembs.solutions.dms.security.model.SystemPermission;
import net.schembs.solutions.dms.security.model.TokenResponse;
import net.schembs.solutions.dms.security.model.User;
import net.schembs.solutions.dms.security.service.SecurityConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private static final String CLIENT_ID = "client_id";
    private static final String GRANT_TYPE = "grant_type";
    private static final String TOKEN_URL = "";
    private static final String GRANT_TYPE_PASSWORD = "password";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    private static final String REFRESH_TOKEN = "refresh_token";
    private static final String TOKEN_SYSTEM_PERMISSION_PREFIX = "dms-";
    private static final String TOKEN_CLIENT_PREFIX = "client-member-";
    private static final String TOKEN_CLIENT_ROLE_PREFIX = "client-role-";
    private final RestTemplate authServerRestTemplate;
    private final TaskScheduler taskScheduler;
    private final AuthConfig.AuthServerConfig authServerConfig;
    private final JwtDecoder jwtDecoder;
    private final SecurityConfigurationService securityConfigurationService;
    private final List<TokenRefreshListener> tokenRefreshListeners = new ArrayList<TokenRefreshListener>();
    private User user;
    private String lastUsername;
    private String lastPassword;

    public boolean isInitialized() {
        return this.securityConfigurationService.isInitialized();
    }

    public void login(String username, String password) {
        LinkedMultiValueMap values = new LinkedMultiValueMap();
        values.add((Object)CLIENT_ID, (Object)this.authServerConfig.getClientId());
        values.add((Object)GRANT_TYPE, (Object)"password");
        values.add((Object)USERNAME, (Object)username);
        values.add((Object)"password", (Object)password);
        HttpEntity request = new HttpEntity((Object)values, (MultiValueMap)AuthService.createHttpHeaders());
        try {
            ResponseEntity result = this.authServerRestTemplate.postForEntity(TOKEN_URL, (Object)request, TokenResponse.class, new Object[0]);
            TokenResponse response = (TokenResponse)result.getBody();
            if (response != null) {
                log.debug("Got token: {} ", (Object)response);
                this.parseToken(username, response);
                if (this.user != null) {
                    log.info("Logged in: {}({})", (Object)this.user.getTitle(), (Object)this.user.getName());
                }
                this.lastUsername = username;
                this.lastPassword = password;
                this.prepareRefresh(response.getExpiresIn());
            } else {
                this.user = null;
                log.warn("Token response is null");
            }
        }
        catch (HttpClientErrorException e) {
            this.user = null;
            throw new LoginFailedException(e);
        }
        if (!this.isAuthenticated()) {
            throw new LoginFailedException("User is null");
        }
    }

    private void prepareRefresh(Integer expiresIn) {
        int refreshInSeconds = expiresIn - 60;
        Instant refreshTime = Instant.now().plusSeconds(refreshInSeconds);
        log.debug("Go for refresh in {} seconds: {}", (Object)refreshInSeconds, (Object)refreshTime);
        this.taskScheduler.schedule(this::refreshToken, refreshTime);
    }

    private void refreshToken() {
        if (this.user != null && this.user.getRefreshToken() != null) {
            log.debug("Try to refresh token");
            HttpHeaders headers = AuthService.createHttpHeaders();
            LinkedMultiValueMap values = new LinkedMultiValueMap();
            values.add((Object)CLIENT_ID, (Object)this.authServerConfig.getClientId());
            values.add((Object)GRANT_TYPE, (Object)"refresh_token");
            values.add((Object)"refresh_token", (Object)this.user.getRefreshToken());
            HttpEntity request = new HttpEntity((Object)values, (MultiValueMap)headers);
            try {
                ResponseEntity result = this.authServerRestTemplate.postForEntity(TOKEN_URL, (Object)request, TokenResponse.class, new Object[0]);
                TokenResponse response = (TokenResponse)result.getBody();
                if (response != null && this.user != null) {
                    log.debug("Got token: {} ", (Object)response);
                    this.user.setAccessToken(response.getAccessToken());
                    this.user.setRefreshToken(response.getRefreshToken());
                    log.info("Access token is refreshed");
                    this.prepareRefresh(response.getExpiresIn());
                } else {
                    this.user = null;
                    log.warn("Token response or user is null");
                    this.onTokenRefreshFailed(new TokenRefreshFailedException("Token response was null or empty"));
                }
            }
            catch (HttpClientErrorException e) {
                this.user = null;
                this.onTokenRefreshFailed(new TokenRefreshFailedException(e));
            }
        }
    }

    public void logout() {
        this.lastUsername = null;
        this.lastPassword = null;
        this.user = null;
    }

    public void reLogin() {
        if (this.lastUsername != null) {
            this.login(this.lastUsername, this.lastPassword);
        }
    }

    private void parseToken(String username, TokenResponse tokenResponse) {
        Jwt jwt = this.jwtDecoder.decode(tokenResponse.getAccessToken());
        this.user = User.builder().accessToken(tokenResponse.getAccessToken()).refreshToken(tokenResponse.getRefreshToken()).name(username).email(jwt.getEmail()).title(jwt.getName()).build();
        for (String role : jwt.getRealmAccess().getRoles()) {
            String roleName;
            if (role.startsWith(TOKEN_CLIENT_PREFIX)) {
                roleName = role.substring(TOKEN_SYSTEM_PERMISSION_PREFIX.length());
                this.user.setClient(roleName);
                continue;
            }
            if (role.startsWith(TOKEN_CLIENT_ROLE_PREFIX)) {
                roleName = role.substring(TOKEN_CLIENT_ROLE_PREFIX.length());
                try {
                    this.user.getDmsPermissions().add(DmsPermission.valueOf(roleName));
                }
                catch (Exception e) {
                    this.user.getUnknownPermissions().add(role);
                }
                continue;
            }
            if (role.startsWith(TOKEN_SYSTEM_PERMISSION_PREFIX)) {
                roleName = role.substring(TOKEN_SYSTEM_PERMISSION_PREFIX.length());
                try {
                    this.user.getSystemPermissions().add(SystemPermission.valueOf(roleName));
                }
                catch (Exception e) {
                    this.user.getUnknownPermissions().add(role);
                }
                continue;
            }
            this.user.getUnknownPermissions().add(role);
        }
        log.debug("User: {}", (Object)this.user);
    }

    public boolean isAuthenticated() {
        return this.user != null && this.user.getAccessToken() != null;
    }

    private static HttpHeaders createHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    private void onTokenRefreshFailed(TokenRefreshFailedException tokenRefreshFailedException) {
        this.tokenRefreshListeners.forEach(listener -> listener.onTokenRefreshFailed(tokenRefreshFailedException));
    }

    @Generated
    public AuthService(RestTemplate authServerRestTemplate, TaskScheduler taskScheduler, AuthConfig.AuthServerConfig authServerConfig, JwtDecoder jwtDecoder, SecurityConfigurationService securityConfigurationService) {
        this.authServerRestTemplate = authServerRestTemplate;
        this.taskScheduler = taskScheduler;
        this.authServerConfig = authServerConfig;
        this.jwtDecoder = jwtDecoder;
        this.securityConfigurationService = securityConfigurationService;
    }

    @Generated
    public List<TokenRefreshListener> getTokenRefreshListeners() {
        return this.tokenRefreshListeners;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    public static interface TokenRefreshListener {
        public void onTokenRefreshFailed(TokenRefreshFailedException var1);
    }
}

