/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Generated;
import net.schembs.solutions.dms.security.jwt.JwtDecoder;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.security.service.BackendUrlProvider;
import net.schembs.solutions.dms.security.service.RootUriSupplierUriTemplateHandler;
import net.schembs.solutions.dms.security.service.SecurityConfigurationService;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

@Configuration
@ConfigurationProperties(prefix="security")
@EnableScheduling
public class AuthConfig {
    private AuthServerConfig authServer;

    @Bean
    public RestTemplate authServerRestTemplate(SecurityConfigurationService securityConfigurationService) {
        RestTemplateBuilder restTemplateBuilder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return restTemplateBuilder.uriTemplateHandler((UriTemplateHandler)new RootUriSupplierUriTemplateHandler(securityConfigurationService::getAuthServerTokenEndpoint)).build();
    }

    @Bean
    public JwtDecoder jwtDecoder(ObjectMapper objectMapper) {
        return new JwtDecoder(objectMapper);
    }

    @Bean
    public AuthService authService(RestTemplate authServerRestTemplate, JwtDecoder jwtDecoder, TaskScheduler taskScheduler, SecurityConfigurationService securityConfigurationService) {
        return new AuthService(authServerRestTemplate, taskScheduler, this.authServer, jwtDecoder, securityConfigurationService);
    }

    @Bean
    public SecurityConfigurationService securityConfigurationService(RestTemplate unsecuredBackendRestTemplate, BackendUrlProvider backendUrlProvider) {
        return new SecurityConfigurationService(unsecuredBackendRestTemplate, backendUrlProvider);
    }

    @Bean
    public RestTemplate unsecuredBackendRestTemplate(BackendUrlProvider backendUrlProvider) {
        return new RestTemplateBuilder(new RestTemplateCustomizer[0]).uriTemplateHandler((UriTemplateHandler)new RootUriSupplierUriTemplateHandler(backendUrlProvider::getBackendUrl)).build();
    }

    @Generated
    public AuthConfig() {
    }

    @Generated
    public AuthServerConfig getAuthServer() {
        return this.authServer;
    }

    @Generated
    public void setAuthServer(AuthServerConfig authServer) {
        this.authServer = authServer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthConfig)) {
            return false;
        }
        AuthConfig other = (AuthConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AuthServerConfig this$authServer = this.getAuthServer();
        AuthServerConfig other$authServer = other.getAuthServer();
        return !(this$authServer == null ? other$authServer != null : !((Object)this$authServer).equals(other$authServer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AuthServerConfig $authServer = this.getAuthServer();
        result = result * 59 + ($authServer == null ? 43 : ((Object)$authServer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthConfig(authServer=" + String.valueOf(this.getAuthServer()) + ")";
    }

    public static class AuthServerConfig {
        private String clientId;

        @Generated
        public AuthServerConfig() {
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthServerConfig)) {
                return false;
            }
            AuthServerConfig other = (AuthServerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthServerConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthConfig.AuthServerConfig(clientId=" + this.getClientId() + ")";
        }
    }
}

