/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.osspecific.win;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.osspecific.win.Win;
import net.schembs.solutions.dms.client.ui.osspecific.OSSpecificFileDialogs;
import org.springframework.stereotype.Component;

@Component
@Win
public class WinFileDialogs
implements OSSpecificFileDialogs {
    private final AppPreferences appPreferences;
    private static final String PREF_KEY_FOLDER = "fileDialogs.folder";

    @Override
    public File[] showOpenDialog(JFrame parent, boolean allowMultiple, List<OSSpecificFileDialogs.Extension> extensions) {
        JFileChooser fileChooser = this.createFileChooser();
        fileChooser.setMultiSelectionEnabled(allowMultiple);
        this.applyFileFilter(extensions, fileChooser);
        if (0 == fileChooser.showOpenDialog(parent)) {
            this.appPreferences.put(PREF_KEY_FOLDER, fileChooser.getCurrentDirectory().getAbsolutePath());
            return fileChooser.getSelectedFiles();
        }
        return new File[0];
    }

    private void applyFileFilter(List<OSSpecificFileDialogs.Extension> extensions, JFileChooser fileChooser) {
        FileFilter defaultFileFilter = null;
        for (OSSpecificFileDialogs.Extension extension : extensions) {
            FileFilter fileFilter = this.createFilterFromExtension(extension);
            fileChooser.addChoosableFileFilter(fileFilter);
            if (defaultFileFilter != null) continue;
            defaultFileFilter = fileFilter;
        }
        if (defaultFileFilter != null) {
            fileChooser.setFileFilter(defaultFileFilter);
        }
    }

    @Override
    public File showSaveDialog(JFrame parent, String filename, List<OSSpecificFileDialogs.Extension> extensions) {
        JFileChooser fileChooser = this.createFileChooser();
        this.applyFileFilter(extensions, fileChooser);
        fileChooser.setSelectedFile(new File(filename));
        if (0 == fileChooser.showSaveDialog(parent)) {
            this.appPreferences.put(PREF_KEY_FOLDER, fileChooser.getCurrentDirectory().getAbsolutePath());
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private FileFilter createFilterFromExtension(OSSpecificFileDialogs.Extension extension) {
        return new FileNameExtensionFilter(extension.getDescription(), extension.getExtension());
    }

    private JFileChooser createFileChooser() {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        String dir = this.appPreferences.get(PREF_KEY_FOLDER);
        if (dir != null) {
            fileChooser.setCurrentDirectory(new File(dir));
        }
        return fileChooser;
    }

    @Override
    public File showFolderDialog(JFrame mainFrame, I18nService i18n) {
        return this.showFolderDialog(mainFrame, i18n, this.appPreferences);
    }

    @Generated
    public WinFileDialogs(AppPreferences appPreferences) {
        this.appPreferences = appPreferences;
    }
}

