/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.osspecific.mac;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.util.List;
import javax.swing.JFrame;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.Mac;
import net.schembs.solutions.dms.client.ui.osspecific.OSSpecificFileDialogs;
import org.springframework.stereotype.Component;

@Component
@Mac
public class MacFileDialogs
implements OSSpecificFileDialogs {
    private final AppPreferences appPreferences;
    private final ActionService actionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] showOpenDialog(JFrame parent, boolean allowMultiple, List<OSSpecificFileDialogs.Extension> extensions) {
        try {
            this.actionService.enableGlobalActionsForNativeDialogs(false);
            FileDialog fileDialog = new FileDialog((Frame)parent, null, 0);
            fileDialog.setDirectory(this.appPreferences.get("fileDialogs.folder"));
            fileDialog.setMultipleMode(allowMultiple);
            fileDialog.setVisible(true);
            File[] results = fileDialog.getFiles();
            if (results != null && fileDialog.getDirectory() != null) {
                this.appPreferences.put("fileDialogs.folder", fileDialog.getDirectory());
            }
            File[] fileArray = results;
            return fileArray;
        }
        finally {
            this.actionService.enableGlobalActionsForNativeDialogs(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File showSaveDialog(JFrame parent, String filename, List<OSSpecificFileDialogs.Extension> extensions) {
        try {
            this.actionService.enableGlobalActionsForNativeDialogs(false);
            FileDialog fileDialog = new FileDialog((Frame)parent, null, 1);
            fileDialog.setDirectory(this.appPreferences.get("fileDialogs.folder"));
            fileDialog.setFile(filename);
            fileDialog.setVisible(true);
            if (fileDialog.getFiles() != null) {
                this.appPreferences.put("fileDialogs.folder", fileDialog.getDirectory());
                File file = fileDialog.getFiles().length > 0 ? fileDialog.getFiles()[0] : null;
                return file;
            }
            File file = null;
            return file;
        }
        finally {
            this.actionService.enableGlobalActionsForNativeDialogs(true);
        }
    }

    @Override
    public File showFolderDialog(JFrame mainFrame, I18nService i18n) {
        return this.showFolderDialog(mainFrame, i18n, this.appPreferences);
    }

    @Generated
    public MacFileDialogs(AppPreferences appPreferences, ActionService actionService) {
        this.appPreferences = appPreferences;
        this.actionService = actionService;
    }
}

