/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.osspecific.mac;

import jakarta.annotation.PostConstruct;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jiconfont.IconCode;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.general.ToolbarIconButton;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.Mac;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacToolBar;
import net.schembs.solutions.dms.client.config.AppConfig;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.Backend;
import net.schembs.solutions.dms.client.service.BackendProvider;
import net.schembs.solutions.dms.client.ui.general.AppDelegateListener;
import net.schembs.solutions.dms.client.ui.osspecific.mac.MacSearchField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Mac
public class AppMacToolBar
extends MacToolBar
implements AppDelegateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppMacToolBar.class);
    private final SettingsService<AppSettings> settingsService;
    private final ActionService actionService;
    private final UIUtils uiUtils;
    private final AppConfig appConfig;
    private final BackendProvider backendProvider;
    private JLabel titleLabel;
    private JComboBox<Backend> cmbBackend;
    private boolean initializing = false;
    private Backend currentBackend;
    private JMenuItem loginMenuItem;
    private JMenuItem logoutMenuItem;
    JPanel actionSection;
    private MacSearchField searchField;

    public AppMacToolBar(UIUtils uiUtils, ActionService actionService, I18nService i18nService, ColorConfig colorConfig, SettingsService<AppSettings> settingsService, ActionService actionService1, UIUtils uiUtils1, AppConfig appConfig, BackendProvider backendProvider) {
        super(uiUtils, actionService, i18nService, colorConfig);
        this.settingsService = settingsService;
        this.actionService = actionService1;
        this.uiUtils = uiUtils1;
        this.appConfig = appConfig;
        this.backendProvider = backendProvider;
    }

    @Override
    @PostConstruct
    public void createUI() {
        super.createUI();
        this.onLoggedOut();
        this.actionService.getAction(Actions.searchSelect).setActionListener(this::onSelectSearch);
    }

    @Override
    protected void configureLeftPanel(JPanel panel) {
        this.titleLabel = new JLabel();
        panel.add(this.titleLabel);
        this.titleLabel.setText(this.appConfig.getName());
        this.cmbBackend = new JComboBox();
        panel.add(this.cmbBackend);
        this.cmbBackend.setVisible(false);
        this.cmbBackend.addActionListener(e -> this.onBackendSelectionChanged());
        panel.add(Box.createHorizontalStrut(10));
        this.actionSection = this.createSection();
        this.actionSection.add(this.createToolButton((IconCode)GoogleMaterialDesignIcons.ADD, Actions.documentNew));
        panel.add(this.actionSection);
    }

    @Override
    protected void configureMidPanel(JPanel panel) {
        JPanel searchSection = this.createSection();
        this.searchField = new MacSearchField(this.uiUtils, this.actionService);
        searchSection.add(this.searchField);
        this.searchField.getActionListeners().add(this::onSearch);
        panel.add(searchSection);
    }

    @Override
    protected void configureRightPanel(JPanel panel) {
        JPanel section = this.createSection();
        section.add(this.createRightMenu());
        panel.add(section);
        panel.add(Box.createHorizontalStrut(10));
    }

    private void onSelectSearch(ActionEvent event) {
        SwingUtilities.invokeLater(() -> this.searchField.requestFocus());
    }

    private JComponent createRightMenu() {
        ToolbarIconButton popupMenuButton = this.createToolButton((IconCode)GoogleMaterialDesignIcons.SETTINGS, Actions.showToolBarMenu);
        JPopupMenu popupMenu = new JPopupMenu();
        this.loginMenuItem = new JMenuItem(this.actionService.getAction(Actions.login));
        popupMenu.add(this.loginMenuItem);
        popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.changePassword)));
        this.logoutMenuItem = new JMenuItem(this.actionService.getAction(Actions.logout));
        popupMenu.add(this.logoutMenuItem);
        this.actionService.getAction(Actions.showToolBarMenu).setActionListener(e -> popupMenu.show(popupMenuButton, 0, popupMenuButton.getHeight()));
        return popupMenuButton;
    }

    @Override
    public void onBackendConfigured() {
        this.initializing = true;
        AppSettings appSettings = this.settingsService.getAppSettings();
        this.cmbBackend.setModel(new DefaultComboBoxModel<Backend>(appSettings.getBackends().toArray(new Backend[0])));
        this.currentBackend = this.backendProvider.getCurrentBackend();
        this.cmbBackend.setSelectedItem(this.currentBackend);
        this.titleLabel.setVisible(this.currentBackend == null);
        this.cmbBackend.setVisible(this.currentBackend != null);
        this.initializing = false;
    }

    @Override
    public void onLoggedIn() {
        this.loginMenuItem.setVisible(false);
        this.logoutMenuItem.setVisible(true);
        this.actionSection.setVisible(true);
    }

    @Override
    public void onLoggedOut() {
        this.loginMenuItem.setVisible(true);
        this.logoutMenuItem.setVisible(false);
        this.titleLabel.setVisible(true);
        this.cmbBackend.setVisible(false);
        this.actionSection.setVisible(false);
    }

    private void onBackendSelectionChanged() {
        Backend selectedBackend = (Backend)this.cmbBackend.getSelectedItem();
        if (!this.initializing && selectedBackend != null && !Objects.equals(selectedBackend.getName(), this.currentBackend.getName())) {
            ActionEvent e = new ActionEvent(this, 1001, selectedBackend.getName());
            this.actionService.getAction(Actions.changeBackend).actionPerformed(e);
        }
    }

    private void onSearch(ActionEvent event) {
        this.actionService.getAction(Actions.search).actionPerformed(event);
    }
}

