/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.osspecific;

import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;

public interface OSSpecificFileDialogs {
    public static final String PREF_KEY_FOLDER = "fileDialogs.folder";

    public File[] showOpenDialog(JFrame var1, boolean var2, List<Extension> var3);

    public File showSaveDialog(JFrame var1, String var2, List<Extension> var3);

    public File showFolderDialog(JFrame var1, I18nService var2);

    default public File showFolderDialog(JFrame mainFrame, final I18nService i18n, AppPreferences appPreferences) {
        JFileChooser chooser = new JFileChooser();
        String folder = appPreferences.get(PREF_KEY_FOLDER);
        if (folder != null) {
            chooser.setCurrentDirectory(new File(folder));
        }
        chooser.setFileSelectionMode(1);
        chooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return i18n.t("fileChooser.directoriesOnly", new Object[0]);
            }
        });
        chooser.setAcceptAllFileFilterUsed(false);
        int result = chooser.showSaveDialog(mainFrame);
        if (result == 0) {
            appPreferences.put(PREF_KEY_FOLDER, chooser.getSelectedFile().getAbsolutePath());
            return chooser.getSelectedFile();
        }
        return null;
    }

    public static class Extension {
        String extension;
        String description;

        @Generated
        Extension(String extension, String description) {
            this.extension = extension;
            this.description = description;
        }

        @Generated
        public static ExtensionBuilder builder() {
            return new ExtensionBuilder();
        }

        @Generated
        public String getExtension() {
            return this.extension;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setExtension(String extension) {
            this.extension = extension;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Extension)) {
                return false;
            }
            Extension other = (Extension)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$extension = this.getExtension();
            String other$extension = other.getExtension();
            if (this$extension == null ? other$extension != null : !this$extension.equals(other$extension)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Extension;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $extension = this.getExtension();
            result = result * 59 + ($extension == null ? 43 : $extension.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OSSpecificFileDialogs.Extension(extension=" + this.getExtension() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public static class ExtensionBuilder {
            @Generated
            private String extension;
            @Generated
            private String description;

            @Generated
            ExtensionBuilder() {
            }

            @Generated
            public ExtensionBuilder extension(String extension) {
                this.extension = extension;
                return this;
            }

            @Generated
            public ExtensionBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public Extension build() {
                return new Extension(this.extension, this.description);
            }

            @Generated
            public String toString() {
                return "OSSpecificFileDialogs.Extension.ExtensionBuilder(extension=" + this.extension + ", description=" + this.description + ")";
            }
        }
    }
}

