/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.osspecific;

import jakarta.annotation.PostConstruct;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.config.OperatingSystem;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.desktopclient.ui.general.AbstractAppDelegate;
import net.schembs.solutions.desktopclient.ui.general.AbstractMainFrame;
import net.schembs.solutions.desktopclient.ui.general.AppToolBar;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutBuilder;
import net.schembs.solutions.desktopclient.ui.osspecific.MainFrameConfigurator;
import net.schembs.solutions.desktopclient.ui.osspecific.mac.MacLeftViewToolBarSpacer;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.ui.general.AppDelegateListener;
import net.schembs.solutions.dms.client.ui.general.DMSStatusBar;
import net.schembs.solutions.dms.client.ui.osspecific.win.WinSearchField;
import net.schembs.solutions.dms.security.model.SystemPermission;
import net.schembs.solutions.dms.security.service.AuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class AppMainFrame
extends AbstractMainFrame
implements AppDelegateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppMainFrame.class);
    private final I18nService i18n;
    private final ActionService actionService;
    private final AuthService authService;
    private final ColorConfig colorConfig;
    private final UIUtils uIUtils;
    private final AppToolBar appToolBar;
    private final DMSStatusBar statusBar;
    private JMenuItem loginMenuItem;
    private JMenuItem logoutMenuItem;
    private JMenuItem adminViewMenuItem;

    public AppMainFrame(AppPreferences appPreferences, AbstractAppDelegate appDelegate, MainFrameConfigurator mainFrameConfigurator, AppLayoutBuilder appLayoutBuilder, I18nService i18n, ActionService actionService, AuthService authService, ColorConfig colorConfig, UIUtils uIUtils, AppToolBar appToolBar, DMSStatusBar statusBar) {
        super(appPreferences, appDelegate, mainFrameConfigurator, appLayoutBuilder);
        this.i18n = i18n;
        this.actionService = actionService;
        this.authService = authService;
        this.colorConfig = colorConfig;
        this.uIUtils = uIUtils;
        this.appToolBar = appToolBar;
        this.statusBar = statusBar;
    }

    @Override
    @PostConstruct
    public void createUI() {
        super.createUI();
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    @Override
    public JComponent getLayoutToolBar(String layoutName) {
        if (OperatingSystem.isMac()) {
            if ("tagTreePanel".equals(layoutName)) {
                return new MacLeftViewToolBarSpacer(this.colorConfig.getBarBackground());
            }
            return this.appToolBar.getComponent();
        }
        return null;
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = this.createFileMenu(menuBar, OperatingSystem.isMac() ? "action.file" : "action.dms");
        this.createDocumentMenu(menuBar, "action.document");
        JMenu helpMenu = this.createHelpMenu(menuBar, OperatingSystem.isMac() ? "action.help" : "?");
        if (OperatingSystem.isWin()) {
            fileMenu.add(new JSeparator());
            fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.quit)));
            helpMenu.insert(new JMenuItem(this.actionService.getAction(Actions.about)), 0);
            menuBar.add(Box.createHorizontalGlue());
            WinSearchField searchField = new WinSearchField(this.uIUtils, this.actionService);
            searchField.getActionListeners().add(this::onSearch);
            this.actionService.getAction(Actions.searchSelect).setActionListener(actionEvent -> SwingUtilities.invokeLater(searchField::requestFocus));
            menuBar.add(searchField);
        }
        return menuBar;
    }

    protected JMenu createFileMenu(JMenuBar menuBar, String actionTitle) {
        JMenu fileMenu = new JMenu(this.i18n.t(actionTitle, new Object[0]));
        menuBar.add(fileMenu);
        this.loginMenuItem = new JMenuItem(this.actionService.getAction(Actions.login));
        fileMenu.add(this.loginMenuItem);
        fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.changePassword)));
        this.logoutMenuItem = new JMenuItem(this.actionService.getAction(Actions.logout));
        fileMenu.add(this.logoutMenuItem);
        fileMenu.add(new JSeparator());
        if (OperatingSystem.isWin()) {
            fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.showSettings)));
        }
        this.adminViewMenuItem = new JMenuItem(this.actionService.getAction(Actions.showAdmin));
        fileMenu.add(this.adminViewMenuItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagAdd)));
        fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagRename)));
        fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagDelete)));
        fileMenu.add(new JSeparator());
        fileMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagsReload)));
        return fileMenu;
    }

    protected JMenu createDocumentMenu(JMenuBar menuBar, String actionTitle) {
        JMenu documentMenu = new JMenu(this.i18n.t(actionTitle, new Object[0]));
        menuBar.add(documentMenu);
        documentMenu.add(new JMenuItem(this.actionService.getAction(Actions.documentNew)));
        documentMenu.add(new JSeparator());
        documentMenu.add(new JMenuItem(this.actionService.getAction(Actions.documentPrint)));
        documentMenu.add(new JMenuItem(this.actionService.getAction(Actions.documentExport)));
        documentMenu.add(new JMenuItem(this.actionService.getAction(Actions.documentMoveToTrash)));
        documentMenu.add(new JSeparator());
        documentMenu.add(new JMenuItem(this.actionService.getAction(Actions.searchSelect)));
        return documentMenu;
    }

    protected JMenu createHelpMenu(JMenuBar menuBar, String actionTitle) {
        JMenu helpMenu = new JMenu(this.i18n.t(actionTitle, new Object[0]));
        menuBar.add(helpMenu);
        helpMenu.add(new JMenuItem(this.actionService.getAction(Actions.releaseNotes)));
        return helpMenu;
    }

    private void onSearch(ActionEvent event) {
        this.actionService.getAction(Actions.search).actionPerformed(event);
    }

    @Override
    public void onBackendConfigured() {
    }

    @Override
    public void onLoggedIn() {
        this.loginMenuItem.setVisible(false);
        this.logoutMenuItem.setVisible(true);
        boolean isAdmin = this.authService.getUser().getSystemPermissions().contains(SystemPermission.admin);
        this.adminViewMenuItem.setVisible(isAdmin);
    }

    @Override
    public void onLoggedOut() {
        this.loginMenuItem.setVisible(true);
        this.logoutMenuItem.setVisible(false);
        this.adminViewMenuItem.setVisible(false);
    }
}

