/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.tag.tree;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.document.list.TaggedDMSDocumentTransferable;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagNodeTransferable;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTree;

public class TagTreeTransferhandler
extends TransferHandler {
    private JTree.DropLocation dropLocation;

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof TagTree) {
            TagTree tree = (TagTree)c;
            DefaultTagTreeNode tagTreeNode = (DefaultTagTreeNode)tree.getSelectionPath().getLastPathComponent();
            return new TagNodeTransferable(tagTreeNode);
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        this.dropLocation = null;
        Object object = support.getDropLocation();
        if (object instanceof JTree.DropLocation) {
            JTree.DropLocation supportDropLocation = (JTree.DropLocation)object;
            object = support.getComponent();
            if (object instanceof TagTree) {
                TagTree tree = (TagTree)object;
                if (support.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
                    Object object2;
                    tree.setDropMode(DropMode.USE_SELECTION);
                    TreePath path = supportDropLocation.getPath();
                    if (path != null && (object2 = path.getLastPathComponent()) instanceof DefaultTagTreeNode) {
                        DefaultTagTreeNode node = (DefaultTagTreeNode)object2;
                        if (node.getTag().isSearchResult() || node.getTag().isSearchResultsContainer() || node.getTag().isQuery()) {
                            return false;
                        }
                        return !node.getTag().isTrash() || support.getDropAction() != 1;
                    }
                    return true;
                }
                if (support.isDataFlavorSupported(TagNodeTransferable.DATA_FLAVOR)) {
                    tree.setDropMode(DropMode.ON_OR_INSERT);
                    this.dropLocation = supportDropLocation;
                    try {
                        DefaultTagTreeNode targetNode = (DefaultTagTreeNode)supportDropLocation.getPath().getLastPathComponent();
                        DefaultTagTreeNode transferredNode = (DefaultTagTreeNode)support.getTransferable().getTransferData(TagNodeTransferable.DATA_FLAVOR);
                        return !this.isParent(transferredNode, targetNode) && !targetNode.getTag().isTrash() && !targetNode.getTag().isQuery();
                    }
                    catch (UnsupportedFlavorException | IOException e) {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    private boolean isParent(DefaultTagTreeNode transferredNode, DefaultTagTreeNode targetNode) {
        for (DefaultTagTreeNode node = targetNode; node != null; node = node.getTagTreeNodeParent()) {
            if (node != transferredNode) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (t.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
            return this.importDMSDocumentData(comp, t);
        }
        if (t.isDataFlavorSupported(TagNodeTransferable.DATA_FLAVOR)) {
            return this.handleReorder(comp, t);
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!support.isDrop() && support.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
            TagTree tree = (TagTree)support.getComponent();
            try {
                TaggedDMSDocuments taggedDMSDocuments = (TaggedDMSDocuments)support.getTransferable().getTransferData(TaggedDMSDocumentTransferable.DATA_FLAVOR);
                tree.onPastedDocuments(taggedDMSDocuments);
                return false;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        return super.importData(support);
    }

    private boolean importDMSDocumentData(JComponent comp, Transferable t) {
        JTree tree = (JTree)comp;
        TreePath path = tree.getSelectionPath();
        if (path != null && path.getLastPathComponent() != null && t.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
            try {
                TaggedDMSDocuments document = (TaggedDMSDocuments)t.getTransferData(TaggedDMSDocumentTransferable.DATA_FLAVOR);
                document.setTagToAdd(((DefaultTagTreeNode)path.getLastPathComponent()).getTag());
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        return false;
    }

    private boolean handleReorder(JComponent comp, Transferable t) {
        TagTree tree = (TagTree)comp;
        TreePath path = this.dropLocation.getPath();
        int idx = this.dropLocation.getChildIndex();
        try {
            int oldIndex;
            DefaultTagTreeNode transferredNode = (DefaultTagTreeNode)t.getTransferData(TagNodeTransferable.DATA_FLAVOR);
            DefaultTagTreeNode oldParent = transferredNode.getTagTreeNodeParent();
            DefaultTagTreeNode newParent = (DefaultTagTreeNode)path.getLastPathComponent();
            DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
            if (oldParent == newParent && (oldIndex = oldParent.getIndex(transferredNode)) < idx) {
                --idx;
            }
            if (idx == -1) {
                idx = newParent.getChildCount();
            }
            model.removeNodeFromParent(transferredNode);
            model.insertNodeInto(transferredNode, newParent, idx);
            tree.expandPath(newParent.getTreePath());
            tree.onReordered();
            return true;
        }
        catch (UnsupportedFlavorException | IOException e) {
            return false;
        }
    }

    @Generated
    public TagTreeTransferhandler() {
    }
}

