/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.tag.tree;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.Tag;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentsPastedListener;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTree;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreeCellEditor;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreeChangedListener;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreeSelectionListener;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreeTransferhandler;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TreeModelAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class TagTreePanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagTreePanel.class);
    private final List<TagTreeSelectionListener> selectionListeners = new ArrayList<TagTreeSelectionListener>();
    private final List<DocumentsPastedListener> documentsPastedListeners = new ArrayList<DocumentsPastedListener>();
    private final DefaultTagTreeNode rootNode = new DefaultTagTreeNode();
    private final List<TagTreeChangedListener> tagTreeChangedListeners = new ArrayList<TagTreeChangedListener>();
    private DefaultTagTreeNode selectedNode;
    private final ActionService actionService;
    private TagTree tree;
    private boolean expanding = false;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.tree = new TagTree();
        JScrollPane sp = new JScrollPane(this.tree);
        sp.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)sp, "Center");
        this.tree.setModel(new DefaultTreeModel(this.rootNode));
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object object;
                if (!TagTreePanel.this.expanding && event != null && event.getPath() != null && (object = event.getPath().getLastPathComponent()) instanceof DefaultTagTreeNode) {
                    DefaultTagTreeNode node = (DefaultTagTreeNode)object;
                    TagTreePanel.this.onExpandNode(node, true);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object object;
                if (!TagTreePanel.this.expanding && event != null && event.getPath() != null && (object = event.getPath().getLastPathComponent()) instanceof DefaultTagTreeNode) {
                    DefaultTagTreeNode node = (DefaultTagTreeNode)object;
                    TagTreePanel.this.onExpandNode(node, false);
                }
            }
        });
        this.tree.addTreeSelectionListener(e -> this.onSelectNode((DefaultTagTreeNode)e.getPath().getLastPathComponent(), this.getTagPath(e.getPath())));
        this.tree.setTransferHandler(new TagTreeTransferhandler());
        this.tree.setDragEnabled(true);
        this.tree.setPopupMenuProvider(this::onProvidePopup);
        this.tree.setEditable(true);
        this.tree.setCellEditor(new TagTreeCellEditor(this.tree, this.actionService));
        this.tree.setDocumentsPastedListener(this::onDocumentsPasted);
        this.tree.setTagTreeChangedListener(this::onTreeChanged);
        this.tree.getModel().addTreeModelListener(new TreeModelAdapter(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                TagTreePanel.this.onTreeChanged();
            }
        });
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
    }

    private String getTagPath(TreePath path) {
        if (path != null && path.getPathCount() > 2) {
            DefaultTagTreeNode node = (DefaultTagTreeNode)path.getLastPathComponent();
            String parentPath = this.getTagPath(path.getParentPath());
            return !parentPath.isEmpty() ? parentPath + "/" + node.getTag().getName() : node.getTag().getName();
        }
        return "";
    }

    private JPopupMenu onProvidePopup(DefaultTagTreeNode tagNode) {
        Tag tag;
        if (tagNode != null && (tag = tagNode.getTag()) != null) {
            JPopupMenu popupMenu = new JPopupMenu();
            if (tagNode.getTag().isSearchResultsContainer()) {
                popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.searchRemoveAllResults)));
            } else if (tagNode.getTag().isSearchResult()) {
                popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.searchRemoveResult)));
            } else {
                if (!tag.isQuery()) {
                    popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagAdd)));
                }
                if (!tag.isRoot()) {
                    popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagRename)));
                }
                if (!(tag.isTrash() || tag.isRoot() || tag.isInbox() || tag.isQuery() || !tagNode.isLeaf())) {
                    popupMenu.add(new JMenuItem(this.actionService.getAction(Actions.tagDelete)));
                }
            }
            return popupMenu;
        }
        return null;
    }

    private void onSelectNode(DefaultTagTreeNode selectedNode, String tagPath) {
        if (this.selectedNode != selectedNode) {
            this.selectedNode = selectedNode;
            this.tree.clearPopupMenuActionNode();
            this.selectionListeners.forEach(l -> l.onTagTreeNodeSelected(selectedNode != null ? selectedNode.getTag() : null, tagPath));
        }
    }

    private void onExpandNode(DefaultTagTreeNode node, boolean expand) {
        node.getTag().setExpanded(expand);
        this.onTreeChanged();
    }

    public void onNewViewModel() {
        this.expanding = true;
        this.updateExpansion(this.rootNode);
        this.expanding = false;
    }

    public void onClearViewModel() {
        this.rootNode.removeAllChildren();
        this.fireNodeStructureChanged(this.rootNode);
    }

    private void updateExpansion(DefaultTagTreeNode node) {
        if (node.getTag().isExpanded()) {
            this.tree.expandPath(node.getTreePath());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateExpansion(node.getTagTreeNodeChildAt(i));
        }
    }

    public void selectNode(DefaultTagTreeNode node) {
        this.tree.scrollPathToVisible(node.getTreePath());
        this.tree.setSelectionPath(node.getTreePath());
    }

    public DefaultTagTreeNode getPopupMenuActionNodeOrSelectedNode() {
        DefaultTagTreeNode popupMenuActionNode = this.getPopupMenuActionNode();
        return popupMenuActionNode != null ? popupMenuActionNode : this.getSelectedNode();
    }

    public DefaultTagTreeNode getPopupMenuActionNode() {
        return this.tree.getPopupMenuActionNode();
    }

    public void expandNode(DefaultTagTreeNode node) {
        this.tree.expandPath(node.getTreePath());
        node.getTag().setExpanded(true);
    }

    public void fireNodeStructureChanged(DefaultTagTreeNode node) {
        ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(node);
    }

    public void onNodeAdded(DefaultTagTreeNode parentNode, DefaultTagTreeNode childNode) {
        this.expandNode(parentNode);
        this.fireNodeStructureChanged(parentNode);
        SwingUtilities.invokeLater(() -> this.tree.startEditingAtPath(childNode.getTreePath()));
    }

    private void onDocumentsPasted(TaggedDMSDocuments taggedDMSDocuments) {
        this.documentsPastedListeners.forEach(l -> l.onPastedDocuments(taggedDMSDocuments));
    }

    public void onNodeRemoved(DefaultTagTreeNode tagNode) {
        DefaultTagTreeNode parent = tagNode.getTagTreeNodeParent();
        tagNode.removeFromParent();
        this.selectNode(parent);
        this.fireNodeStructureChanged(parent);
    }

    private void onTreeChanged() {
        this.tagTreeChangedListeners.forEach(TagTreeChangedListener::onTreeChanged);
    }

    public void startEditing(DefaultTagTreeNode node) {
        SwingUtilities.invokeLater(() -> this.tree.startEditingAtPath(node.getTreePath()));
    }

    @Generated
    public TagTreePanel(ActionService actionService) {
        this.actionService = actionService;
    }

    @Generated
    public List<TagTreeSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    @Generated
    public List<DocumentsPastedListener> getDocumentsPastedListeners() {
        return this.documentsPastedListeners;
    }

    @Generated
    public DefaultTagTreeNode getRootNode() {
        return this.rootNode;
    }

    @Generated
    public List<TagTreeChangedListener> getTagTreeChangedListeners() {
        return this.tagTreeChangedListeners;
    }

    @Generated
    public DefaultTagTreeNode getSelectedNode() {
        return this.selectedNode;
    }
}

