/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.tag.tree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import lombok.Generated;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentsPastedListener;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;
import net.schembs.solutions.dms.client.ui.general.tag.tree.TagTreeChangedListener;

public class TagTree
extends JTree {
    private DefaultTagTreeNode popupMenuActionNode;
    private PopupMenuProvider popupMenuProvider;
    private DocumentsPastedListener documentsPastedListener;
    private TagTreeChangedListener tagTreeChangedListener;

    public TagTree() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TagTree.this.onPopupTriggered(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TagTree.this.onPopupTriggered(e);
                }
            }
        });
    }

    private void onPopupTriggered(MouseEvent e) {
        JPopupMenu popupMenu;
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        this.popupMenuActionNode = null;
        Object menuTag = null;
        if (path != null) {
            this.popupMenuActionNode = (DefaultTagTreeNode)path.getLastPathComponent();
        }
        JPopupMenu jPopupMenu = popupMenu = this.popupMenuProvider != null ? this.popupMenuProvider.getPopupMenuFor(this.popupMenuActionNode) : null;
        if (popupMenu != null) {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void clearPopupMenuActionNode() {
        this.popupMenuActionNode = null;
    }

    public void onPastedDocuments(TaggedDMSDocuments taggedDMSDocuments) {
        if (this.documentsPastedListener != null) {
            this.documentsPastedListener.onPastedDocuments(taggedDMSDocuments);
        }
    }

    public void onReordered() {
        if (this.tagTreeChangedListener != null) {
            this.tagTreeChangedListener.onTreeChanged();
        }
    }

    @Generated
    public DefaultTagTreeNode getPopupMenuActionNode() {
        return this.popupMenuActionNode;
    }

    @Generated
    public void setPopupMenuProvider(PopupMenuProvider popupMenuProvider) {
        this.popupMenuProvider = popupMenuProvider;
    }

    @Generated
    public void setDocumentsPastedListener(DocumentsPastedListener documentsPastedListener) {
        this.documentsPastedListener = documentsPastedListener;
    }

    @Generated
    public void setTagTreeChangedListener(TagTreeChangedListener tagTreeChangedListener) {
        this.tagTreeChangedListener = tagTreeChangedListener;
    }

    public static interface PopupMenuProvider {
        public JPopupMenu getPopupMenuFor(DefaultTagTreeNode var1);
    }
}

