/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.settings.backend;

import jakarta.annotation.PostConstruct;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import org.springframework.stereotype.Component;

@Component
public class NewBackendPanel
extends JPanel {
    private final I18nService i18n;
    private JTextField urlField;
    public Consumer<String> onUrlChanged;

    @PostConstruct
    public void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new VerticalLayout(2));
        this.add(new JLabel(this.i18n.t("settings.backend.url", new Object[0])));
        this.urlField = new JTextField();
        this.add(this.urlField);
        this.urlField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewBackendPanel.this.onUrlChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewBackendPanel.this.onUrlChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewBackendPanel.this.onUrlChanged();
            }
        });
        this.onUrlChanged();
    }

    private void onUrlChanged() {
        if (this.onUrlChanged != null) {
            this.onUrlChanged.accept(this.urlField.getText());
        }
    }

    public void setUrl(String s) {
        this.urlField.setText(s);
        this.onUrlChanged();
    }

    public String getUrl() {
        return this.urlField.getText();
    }

    @Generated
    public NewBackendPanel(I18nService i18n) {
        this.i18n = i18n;
    }

    @Generated
    public void setOnUrlChanged(Consumer<String> onUrlChanged) {
        this.onUrlChanged = onUrlChanged;
    }
}

