/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.settings;

import jakarta.annotation.PostConstruct;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.settings.SettingsCategoryPanel;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.DropDownValue;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.SettingEditorHelper;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.AppSettings;
import org.springframework.stereotype.Component;

@Component
public class SettingsCategoryGeneralPanel
extends JPanel
implements SettingsCategoryPanel<AppSettings> {
    private final AppColorConfig colorConfig;
    private final I18nService i18n;
    private final SettingEditorHelper<AppSettings> settingEditorHelper = new SettingEditorHelper();
    private JComponent firstComponent;
    private Runnable requestFocusOnMenu;

    @PostConstruct
    public void createUI() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.setBackground(this.colorConfig.getBarBackground());
        JPanel panel = new JPanel(new VerticalLayout(8));
        panel = new JPanel(new GridLayout(0, 2));
        panel.setOpaque(false);
        this.firstComponent = this.settingEditorHelper.configureAsFirst(this.settingEditorHelper.createDropDown(panel, this.i18n.t("settings.general.theme", new Object[0]), "general.theme", Stream.of("dark", "light", "system").map(v -> DropDownValue.builder().value((String)v).title(this.i18n.t("settings.theme." + v, new Object[0])).build()).toList()), () -> this.requestFocusOnMenu).getEditorComponent();
        this.settingEditorHelper.createCheckBox(panel, this.i18n.t("settings.general.tables", new Object[0]), this.i18n.t("settings.general.tablesAlternateColors", new Object[0]), "general.showAlternateTableColor");
        this.settingEditorHelper.createCheckBox(panel, this.i18n.t("settings.general.confirm", new Object[0]), this.i18n.t("settings.general.confirmExit", new Object[0]), "general.confirmClose");
        this.settingEditorHelper.createCheckBox(panel, this.i18n.t("", new Object[0]), this.i18n.t("settings.general.confirmDeleteDocument", new Object[0]), "app.confirmDeleteDocument");
        this.settingEditorHelper.configureAsLast(this.settingEditorHelper.createCheckBox(panel, this.i18n.t("", new Object[0]), this.i18n.t("settings.general.confirmDeleteTag", new Object[0]), "app.confirmDeleteTag"));
        this.add(panel);
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settingEditorHelper.setSettings(settings);
    }

    @Override
    public void setFocusOnMenuRequester(Runnable requestFocusOnMenu) {
        this.requestFocusOnMenu = requestFocusOnMenu;
    }

    @Override
    public void requestFocusOnFirstComponent() {
        this.firstComponent.requestFocus();
    }

    @Generated
    public SettingsCategoryGeneralPanel(AppColorConfig colorConfig, I18nService i18n) {
        this.colorConfig = colorConfig;
        this.i18n = i18n;
    }
}

