/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.settings;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.model.TableSelection;
import net.schembs.solutions.desktopclient.service.ComponentHelper;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import net.schembs.solutions.desktopclient.ui.general.OkCancelDialog;
import net.schembs.solutions.desktopclient.ui.general.settings.SettingsCategoryPanel;
import net.schembs.solutions.desktopclient.ui.general.settings.editors.SettingEditorHelper;
import net.schembs.solutions.dms.client.backend.info.api.model.BackendInfo;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.Backend;
import net.schembs.solutions.dms.client.service.BackendInfoService;
import net.schembs.solutions.dms.client.ui.general.settings.backend.BackendTableModel;
import net.schembs.solutions.dms.client.ui.general.settings.backend.BackendsTable;
import net.schembs.solutions.dms.client.ui.general.settings.backend.NewBackendPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class SettingsCategoryBackendPanel
extends JPanel
implements SettingsCategoryPanel<AppSettings> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SettingsCategoryBackendPanel.class);
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final ColorConfig colorConfig;
    private final SettingsService<AppSettings> settingsService;
    private final BackendInfoService backendInfoService;
    private final SettingEditorHelper<AppSettings> settingEditorHelper = new SettingEditorHelper();
    private final NewBackendPanel newBackendPanel;
    private AppSettings settings;
    private BackendsTable table;
    private BackendTableModel tableModel;
    private JButton btnAdd;
    private JButton btnDelete;
    private Runnable requestFocusOnMenu;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new BackendsTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.tableModel = new BackendTableModel(this.i18n);
        this.table.setModel(this.tableModel);
        this.add((Component)scrollPane, "Center");
        JPanel btnPanel = new JPanel(new FlowLayout(3));
        this.btnAdd = new JButton("+");
        btnPanel.add(this.btnAdd);
        this.btnAdd.addActionListener(this::onAddBackend);
        this.btnDelete = new JButton("-");
        btnPanel.add(this.btnDelete);
        this.btnDelete.addActionListener(this::onDeleteBackend);
        this.add((Component)btnPanel, "South");
        this.settingEditorHelper.configureAsFirst(this.table, () -> this.requestFocusOnMenu);
        KeyboardHelper.registerActionOnComponent((JComponent)this.table, "cmd down", () -> this.btnAdd.requestFocus());
        KeyboardHelper.registerActionOnComponent((JComponent)this.btnAdd, "cmd up", () -> this.table.requestFocus());
        KeyboardHelper.registerActionOnComponent((JComponent)this.btnAdd, "cmd right", () -> this.btnDelete.requestFocus());
        KeyboardHelper.registerActionOnComponent((JComponent)this.btnDelete, "cmd up", () -> this.table.requestFocus());
        KeyboardHelper.registerActionOnComponent((JComponent)this.btnDelete, "cmd left", () -> this.btnAdd.requestFocus());
        ComponentHelper.registerClose(this.table, this.btnAdd, this.btnDelete);
    }

    private void onAddBackend(ActionEvent actionEvent) {
        OkCancelDialog dialog = new OkCancelDialog(SwingUtilities.getWindowAncestor(this), this.i18n);
        dialog.setTitle(this.i18n.t("settings.backend.new.title", new Object[0]));
        dialog.createUI();
        dialog.getContentPane().add((Component)this.newBackendPanel, "Center");
        dialog.pack();
        dialog.center();
        this.newBackendPanel.setOnUrlChanged(s -> dialog.setOkButtonEnabled(s != null && !s.trim().isEmpty()));
        this.newBackendPanel.setUrl("");
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            this.testBackEnd(this.newBackendPanel.getUrl());
        }
    }

    private void testBackEnd(String url) {
        try {
            String theUrl = url.trim().toLowerCase();
            if (this.settings.getBackends().stream().anyMatch(b -> b.getUrl().equals(theUrl))) {
                JOptionPane.showMessageDialog(this, this.i18n.t("settings.backend.alreadyExists", theUrl), this.i18n.t("error.title", new Object[0]), 0);
                return;
            }
            BackendInfo backendInfo = this.backendInfoService.getBackendInfo(theUrl);
            log.info("Backend info: {}", (Object)backendInfo);
            this.settings.getBackends().add(Backend.builder().name(backendInfo.getName()).url(theUrl).build());
            this.updateSettings();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, this.i18n.t("settings.backend.notFound", url), this.i18n.t("error.title", new Object[0]), 0);
        }
    }

    private void updateSettings() {
        this.setSettings(this.settings);
        this.table.cacheSelection();
        this.tableModel.fireTableDataChanged();
        this.table.restoreSelection();
    }

    private void onDeleteBackend(ActionEvent actionEvent) {
        TableSelection selection = this.table.getSelection();
        for (Object rowId : selection.getSelectedRowIds()) {
            this.settings.getBackends().removeIf(b -> b.getRowId().equals(rowId));
        }
        this.updateSettings();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void setSettings(AppSettings settings) {
        this.settings = settings;
        this.tableModel.setBackends(settings.getBackends());
        this.table.selectRow(0, false);
    }

    @Override
    public void setFocusOnMenuRequester(Runnable requestFocusOnMenu) {
        this.requestFocusOnMenu = requestFocusOnMenu;
    }

    @Override
    public void requestFocusOnFirstComponent() {
        this.table.requestFocus();
    }

    @Generated
    public SettingsCategoryBackendPanel(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<AppSettings> settingsService, BackendInfoService backendInfoService, NewBackendPanel newBackendPanel) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
        this.backendInfoService = backendInfoService;
        this.newBackendPanel = newBackendPanel;
    }
}

