/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.pdf;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfRendererPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PdfRendererPanel.class);
    private BufferedImage image;
    private double scale = 1.0;
    private final Point startPoint = new Point(0, 0);
    private final Point delta = new Point(0, 0);

    public PdfRendererPanel(AppColorConfig colorConfig) {
        this.setLayout(new BorderLayout());
        this.setBackground(colorConfig.getPDFRendererBackground());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                PdfRendererPanel.this.showMove(e.getPoint());
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PdfRendererPanel.this.startPoint.setLocation(e.getPoint().x - PdfRendererPanel.this.delta.x, e.getPoint().y - PdfRendererPanel.this.delta.y);
            }
        });
    }

    private void showMove(Point point) {
        this.delta.setLocation(point.x - this.startPoint.x, point.y - this.startPoint.y);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        if (this.image != null) {
            int targetWidth = size.width;
            int targetHeight = size.height;
            int sourceWidth = this.image.getWidth();
            int sourceHeight = this.image.getHeight();
            int newWidth = targetWidth;
            int newHeight = (int)((double)targetWidth * ((double)sourceHeight / (double)sourceWidth));
            if (newHeight > targetHeight) {
                newHeight = targetHeight;
                newWidth = (int)((double)targetHeight * ((double)sourceWidth / (double)sourceHeight));
            }
            newWidth = (int)((double)newWidth * this.scale);
            newHeight = (int)((double)newHeight * this.scale);
            int dx = (targetWidth - newWidth) / 2 + this.delta.x;
            int dy = (targetHeight - newHeight) / 2 + this.delta.y;
            g.drawImage(this.image, dx, dy, newWidth, newHeight, null);
        }
    }

    public void resetDelta() {
        this.delta.setLocation(0, 0);
    }

    @Generated
    public void setImage(BufferedImage image) {
        this.image = image;
    }

    @Generated
    public void setScale(double scale) {
        this.scale = scale;
    }
}

