/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.pdf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jiconfont.IconCode;
import jiconfont.icons.google_material_design_icons.GoogleMaterialDesignIcons;
import lombok.Generated;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.ui.general.pdf.PdfRendererPanel;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PDFPreviewPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PDFPreviewPanel.class);
    public static final int MINIMUM_SCALE = 10;
    public static final int MAXIMUM_SCALE = 250;
    private PDDocument pdfDocument;
    private final PdfRendererPanel pdfRendererPanel;
    private final JLabel pageInfo;
    private final JButton prevPage;
    private final JButton nextPage;
    protected final JPanel pageSelectorPanel;
    private final JSlider scaleSlider;
    protected int currentPage = 0;
    protected int pageCount = 0;
    private JLabel sliderValue;
    private final List<PageSelectionListener> pageSelectionListeners = new ArrayList<PageSelectionListener>();

    public PDFPreviewPanel(UIUtils uiUtils, AppColorConfig config) {
        this.setLayout(new BorderLayout());
        this.pdfRendererPanel = new PdfRendererPanel(config);
        this.add((Component)this.pdfRendererPanel, "Center");
        this.pageSelectorPanel = new JPanel(new FlowLayout());
        this.prevPage = new JButton(uiUtils.getFontIcon((IconCode)GoogleMaterialDesignIcons.ARROW_BACK, 16));
        this.prevPage.addActionListener(e -> this.renderPage(this.currentPage - 1));
        this.nextPage = new JButton(uiUtils.getFontIcon((IconCode)GoogleMaterialDesignIcons.ARROW_FORWARD, 16));
        this.nextPage.addActionListener(e -> this.renderPage(this.currentPage + 1));
        this.pageInfo = new JLabel("-");
        this.pageSelectorPanel.add(this.prevPage);
        this.pageSelectorPanel.add(this.pageInfo);
        this.pageSelectorPanel.add(this.nextPage);
        JPanel selectorHolder = new JPanel(new BorderLayout());
        JPanel scalePanel = new JPanel(new BorderLayout());
        scalePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 20));
        this.scaleSlider = new JSlider();
        this.scaleSlider.setMinimum(10);
        this.scaleSlider.setMaximum(250);
        this.scaleSlider.addChangeListener(e -> this.onScaleChanged());
        scalePanel.add((Component)this.scaleSlider, "Center");
        this.sliderValue = new JLabel("100%");
        scalePanel.add((Component)this.sliderValue, "East");
        this.sliderValue.setMinimumSize(new Dimension(100, 10));
        selectorHolder.add((Component)scalePanel, "South");
        selectorHolder.add((Component)this.pageSelectorPanel, "Center");
        this.add((Component)selectorHolder, "South");
        this.scaleSlider.setValue(100);
        this.updateInfo();
    }

    private void onScaleChanged() {
        this.sliderValue.setText(this.scaleSlider.getValue() + "%");
        this.pdfRendererPanel.setScale((double)this.scaleSlider.getValue() / 100.0);
        this.pdfRendererPanel.revalidate();
        this.pdfRendererPanel.repaint();
    }

    public void loadDocument(File file, int showPage) {
        try {
            PDDocument pdfDocument = file != null ? Loader.loadPDF((File)file) : null;
            this.scaleSlider.setValue(100);
            this.pdfRendererPanel.resetDelta();
            this.loadDocument(pdfDocument, showPage);
        }
        catch (IOException e) {
            log.warn("Unable to load document {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    public void loadDocument(PDDocument document, int showPage) {
        this.pdfDocument = document;
        this.onScaleChanged();
        this.renderPage(showPage);
    }

    public void renderPage(int page) {
        BufferedImage image = null;
        if (this.pdfDocument != null) {
            this.pageCount = this.pdfDocument.getNumberOfPages();
            if (page < 1) {
                page = 1;
            }
            if (page > this.pageCount) {
                page = this.pageCount;
            }
            this.currentPage = page;
            this.pageInfo.setText(page + "/" + this.pdfDocument.getNumberOfPages());
            PDFRenderer renderer = new PDFRenderer(this.pdfDocument);
            try {
                image = renderer.renderImage(page - 1);
            }
            catch (Exception e) {
                log.warn("Unable to render document");
            }
        } else {
            this.currentPage = 0;
            this.pageCount = 0;
        }
        this.pdfRendererPanel.setImage(image);
        this.updateInfo();
        this.pdfRendererPanel.revalidate();
        this.pdfRendererPanel.repaint();
        this.pageSelectionListeners.forEach(l -> l.onPageSelected(this.currentPage));
    }

    private BufferedImage createErrorImage() {
        int w = 800;
        int h = 600;
        BufferedImage img = new BufferedImage(w, h, 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setPaint(Color.red);
        String s = "Hello, world!";
        FontMetrics fm = g2d.getFontMetrics();
        int x = img.getWidth() - fm.stringWidth(s) - 5;
        int y = fm.getHeight();
        g2d.drawString(s, x, y);
        g2d.dispose();
        return img;
    }

    protected void updateInfo() {
        this.pageInfo.setText(this.currentPage + "/" + this.pageCount);
        this.prevPage.setEnabled(this.currentPage > 1);
        this.nextPage.setEnabled(this.currentPage < this.pageCount);
        this.scaleSlider.setEnabled(this.pdfDocument != null);
    }

    @Generated
    public List<PageSelectionListener> getPageSelectionListeners() {
        return this.pageSelectionListeners;
    }

    public static interface PageSelectionListener {
        public void onPageSelected(int var1);
    }
}

