/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.error;

import java.time.Instant;
import java.util.List;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.dms.client.model.AppError;
import net.schembs.solutions.dms.client.model.LocalizedText;

public class ErrorTableModel
extends AbstractXTableModel<AppError> {
    public ErrorTableModel(I18nService i18n) {
        super(i18n);
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            AppError error = (AppError)this.rows.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> LocalizedText.builder().text(error.getErrorCode().toString()).params(error.getParams()).build();
                case 1 -> error.getTimestamp();
                case 2 -> error.isViewed();
                default -> null;
            };
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    @Override
    public List<String> getColumnTitles() {
        return List.of("errorTable.title.message", "errorTable.title.timestamp", "errorTable.title.viewed");
    }

    @Override
    public String getTableId() {
        return "errorTable";
    }

    @Override
    public TableColumnModel getDefaultTableColumnModel() {
        return TableColumnModel.builder().columnWidths(new int[]{600, 150, 50}).build();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> LocalizedText.class;
            case 1 -> Instant.class;
            default -> super.getColumnClass(column);
        };
    }

    public void updateErrors(List<AppError> errors) {
        this.rows.clear();
        this.rows.addAll(errors);
    }
}

