/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.error;

import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.dms.client.model.AppError;

public class ErrorShowPane
extends JOptionPane {
    private final I18nService i18n;
    private final AppError appError;

    public static void showErrorWithDetails(JFrame parent, AppError appError, I18nService i18n) {
        ErrorShowPane pane = new ErrorShowPane(appError, i18n);
        JDialog dialog = pane.createDialog(parent, i18n.t("error.title", new Object[0]));
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.dispose();
    }

    public ErrorShowPane(AppError appError, I18nService i18n) {
        this.i18n = i18n;
        this.appError = appError;
        JButton obButton = new JButton(i18n.t("button.ok", new Object[0]));
        obButton.addActionListener(this::onOk);
        JButton detailsButton = new JButton(i18n.t("button.details", new Object[0]));
        detailsButton.addActionListener(this::onDetails);
        this.setOptionType(-1);
        this.setOptions(new JButton[]{obButton, detailsButton});
        this.setInputValue(obButton);
        this.setMessageType(0);
        this.setMessage(this.getErrorMessage(appError));
        if (appError.getThrowable() == null) {
            detailsButton.setVisible(false);
        }
    }

    private void onOk(ActionEvent actionEvent) {
        this.setValue(0);
    }

    private void onDetails(ActionEvent actionEvent) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.appError.getThrowable().printStackTrace(pw);
        JOptionPane.showMessageDialog(this, sw.toString(), this.appError.getThrowable().getClass().getSimpleName(), 0);
    }

    private String getErrorMessage(AppError appError) {
        return this.i18n.t(appError.getErrorCode().toString(), appError.getParams() != null ? appError.getParams().toArray() : null);
    }
}

