/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.view;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.dms.client.model.DateTimeFormat;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentAttribute;

public class DocumentAttributesTableModel
extends AbstractXTableModel<DocumentAttribute> {
    private final DateTimeFormatter dateFormatter;
    private final DateTimeFormatter dateTimeFormatter;

    public DocumentAttributesTableModel(I18nService i18n) {
        super(i18n);
        this.dateFormatter = DateTimeFormatter.ofPattern(i18n.t(DateTimeFormat.dmy.toString(), new Object[0])).withZone(ZoneId.systemDefault());
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(i18n.t(DateTimeFormat.dmyHms.toString(), new Object[0])).withZone(ZoneId.systemDefault());
    }

    @Override
    public String getTableId() {
        return "documentAttributesTable";
    }

    @Override
    public TableColumnModel getDefaultTableColumnModel() {
        return TableColumnModel.builder().columnWidths(new int[]{200, 600}).build();
    }

    @Override
    public List<String> getColumnTitles() {
        return List.of(this.getI18n().t("document.attribute", new Object[0]), this.getI18n().t("document.attributeValue", new Object[0]));
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return switch (columnIndex) {
                case 0 -> this.getI18n().t(((DocumentAttribute)this.rows.get(rowIndex)).getKey(), new Object[0]);
                case 1 -> this.render(((DocumentAttribute)this.rows.get(rowIndex)).getValue());
                default -> null;
            };
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private String render(Object value) {
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return this.dateFormatter.format(date);
        }
        if (value instanceof OffsetDateTime) {
            OffsetDateTime dateTime = (OffsetDateTime)value;
            return this.dateTimeFormatter.format(dateTime);
        }
        return value != null ? value.toString() : null;
    }

    public void setDocument(DmsDocument document, String currentTagName, List<String> tags) {
        this.rows.clear();
        if (document != null) {
            this.rows.add(DocumentAttribute.builder().key("document.id").value(document.getId()).build());
            this.rows.add(DocumentAttribute.builder().key("document.description").value(document.getDescription()).build());
            this.rows.add(DocumentAttribute.builder().key("document.date").value(document.getDocumentDate()).build());
            this.rows.add(DocumentAttribute.builder().key("document.status").value((Object)document.getStatus()).build());
            this.rows.add(DocumentAttribute.builder().key("document.owner").value(document.getOwner()).build());
            this.rows.add(DocumentAttribute.builder().key("document.assignee").value(document.getAssignee()).build());
            this.rows.add(DocumentAttribute.builder().key("document.createUser").value(document.getCreateUser()).build());
            this.rows.add(DocumentAttribute.builder().key("document.createDate").value(document.getCreateDate()).build());
            this.rows.add(DocumentAttribute.builder().key("document.changeUser").value(document.getChangeUser()).build());
            this.rows.add(DocumentAttribute.builder().key("document.changeDate").value(document.getChangeDate()).build());
            if (currentTagName != null) {
                this.rows.add(DocumentAttribute.builder().key("document.tag").value(currentTagName).build());
            }
            if (tags != null) {
                tags.remove(currentTagName);
                for (String tag : tags) {
                    this.rows.add(DocumentAttribute.builder().key("document.tag").value(tag).build());
                }
            }
        }
        this.fireTableDataChanged();
    }
}

