/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.view;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.DocumentAttribute;
import net.schembs.solutions.dms.client.ui.general.document.view.DocumentAttributesTable;
import net.schembs.solutions.dms.client.ui.general.document.view.DocumentAttributesTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class DocumentAttributesPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentAttributesPanel.class);
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final ColorConfig colorConfig;
    private final SettingsService<AppSettings> settingsService;
    private final List<DocumentAttributeSelectionListener> selectionListeners = new ArrayList<DocumentAttributeSelectionListener>();
    private final List<DocumentAttributeClickListener> clickListeners = new ArrayList<DocumentAttributeClickListener>();
    private DocumentAttributesTable table;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new DocumentAttributesTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        this.table.setModel(new DocumentAttributesTableModel(this.i18n));
        this.table.getListSelectionListeners().add(this::onSelectAttribute);
        this.table.getClickListeners().add(this::onAttributeDoubleClicked);
    }

    private void onSelectAttribute(int[] selectedModelIndices) {
        this.selectionListeners.forEach(l -> l.onAttributeSelected(this.getSelectedAttribute()));
    }

    private void onAttributeDoubleClicked(int[] selectedModelIndices) {
        this.clickListeners.forEach(l -> l.onAttributeDoubleClicked(this.getSelectedAttribute()));
    }

    private DocumentAttribute getSelectedAttribute() {
        int idx = this.table.getSelectedModelRowIndex();
        if (idx >= 0 && idx < this.table.getRowCount()) {
            return (DocumentAttribute)((DocumentAttributesTableModel)this.table.getModel()).getRows().get(idx);
        }
        return null;
    }

    public void setModel(DocumentAttributesTableModel attributesTableModel) {
        this.table.setModel(attributesTableModel);
    }

    @Generated
    public DocumentAttributesPanel(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
    }

    @Generated
    public List<DocumentAttributeSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    @Generated
    public List<DocumentAttributeClickListener> getClickListeners() {
        return this.clickListeners;
    }

    public static interface DocumentAttributeClickListener {
        public void onAttributeDoubleClicked(DocumentAttribute var1);
    }

    public static interface DocumentAttributeSelectionListener {
        public void onAttributeSelected(DocumentAttribute var1);
    }
}

