/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.pdfedit;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageTransferable;

public class PageTransferHandler
extends TransferHandler {
    private int targetIndex;
    private final PageMoveListener pageMoveListener;

    public PageTransferHandler(PageMoveListener pageMoveListener) {
        this.pageMoveListener = pageMoveListener;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JList) {
            JList list = (JList)c;
            return new PageTransferable(list.getSelectedIndex());
        }
        return null;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(PageTransferable.DATA_FLAVOR)) {
            JList.DropLocation dl = (JList.DropLocation)support.getDropLocation();
            this.targetIndex = dl.getIndex();
            return this.targetIndex >= -1;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent comp, Transferable data) {
        if (data != null && data.isDataFlavorSupported(PageTransferable.DATA_FLAVOR)) {
            try {
                int sourceIndex = (Integer)data.getTransferData(PageTransferable.DATA_FLAVOR);
                this.pageMoveListener.onMovePage(sourceIndex, this.targetIndex);
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                return false;
            }
        }
        return false;
    }

    public static interface PageMoveListener {
        public void onMovePage(int var1, int var2);
    }
}

