/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.pdfedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import lombok.Generated;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageListCellRenderer;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageListModel;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageTransferHandler;

public class PageListView
extends JPanel {
    JList<BufferedImage> pageList;
    PageListModel pageListModel;
    private final List<PageSelectionListener> pageSelectionListeners = new ArrayList<PageSelectionListener>();
    private final List<PageTransferHandler.PageMoveListener> pageMoveListeners = new ArrayList<PageTransferHandler.PageMoveListener>();
    private boolean selecting;

    public PageListView(AppColorConfig colorConfig) {
        this.setLayout(new BorderLayout());
        this.pageList = new JList();
        this.pageListModel = new PageListModel();
        this.pageList.setModel(this.pageListModel);
        this.pageList.setCellRenderer(new PageListCellRenderer(colorConfig));
        this.pageList.addListSelectionListener(this::onPageSelected);
        JScrollPane scroller = new JScrollPane(this.pageList);
        scroller.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scroller, "Center");
        this.pageList.setDragEnabled(true);
        this.pageList.setDropMode(DropMode.ON_OR_INSERT);
        this.pageList.setTransferHandler(new PageTransferHandler(this::onMovePage));
    }

    private void onPageSelected(ListSelectionEvent listSelectionEvent) {
        if (!this.selecting) {
            this.pageSelectionListeners.forEach(l -> l.onPageSelected(this.pageList.getSelectedIndex()));
        }
    }

    public void setPageCount(int numberOfPages) {
        this.pageListModel.setSize(numberOfPages);
        this.pageList.setSelectedIndex(0);
    }

    public void updatePageImages(List<BufferedImage> pageImages) {
        this.pageListModel.setImages(pageImages);
        this.pageList.revalidate();
        this.pageList.repaint();
    }

    public void markSelection(int pageIndex) {
        this.selecting = true;
        this.pageList.setSelectedIndex(pageIndex);
        this.selecting = false;
    }

    public void onMovePage(int sourceIndex, int targetIndex) {
        this.pageMoveListeners.forEach(l -> l.onMovePage(sourceIndex, targetIndex));
    }

    @Generated
    public List<PageSelectionListener> getPageSelectionListeners() {
        return this.pageSelectionListeners;
    }

    @Generated
    public List<PageTransferHandler.PageMoveListener> getPageMoveListeners() {
        return this.pageMoveListeners;
    }

    public static interface PageSelectionListener {
        public void onPageSelected(int var1);
    }
}

