/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.pdfedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import net.schembs.solutions.dms.client.config.AppColorConfig;

public class PageListCellRenderer
extends JPanel
implements ListCellRenderer<BufferedImage> {
    private final JLabel imageLabel;
    private final JLabel indexLabel;
    private final AppColorConfig colorConfig;

    public PageListCellRenderer(AppColorConfig colorConfig) {
        this.colorConfig = colorConfig;
        this.setLayout(new BorderLayout());
        this.imageLabel = new JLabel();
        this.add((Component)this.imageLabel, "Center");
        this.indexLabel = new JLabel();
        this.add((Component)this.indexLabel, "South");
        this.imageLabel.setBorder(BorderFactory.createEmptyBorder(20, 5, 5, 5));
        this.imageLabel.setHorizontalAlignment(0);
        this.indexLabel.setHorizontalAlignment(0);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends BufferedImage> list, BufferedImage value, int index, boolean isSelected, boolean cellHasFocus) {
        int width = 200;
        int height = (int)((double)width * 1.414);
        this.setBackground(isSelected ? this.colorConfig.getSelectionBackground() : this.colorConfig.getBarBackground());
        if (value != null && value.getWidth() > value.getHeight()) {
            height = (int)((double)width / 1.414);
        }
        BufferedImage img = value != null ? value.getScaledInstance(width, height, 4) : PageListCellRenderer.getEmptyImage(width, height);
        ImageIcon icon = new ImageIcon(img);
        this.imageLabel.setIcon(icon);
        this.indexLabel.setText(Integer.toString(index + 1));
        return this;
    }

    private static BufferedImage getEmptyImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        return image;
    }
}

