/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.pdfedit;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.model.RectangleWrapper;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.BackgroundRenderer;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageListView;
import net.schembs.solutions.dms.client.ui.general.document.pdfedit.PageView;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

@org.springframework.stereotype.Component
public class PDFEditPanel
extends JPanel {
    public static final String PREF_KEY = "pdfEditor.bounds";
    private static final String PREF_KEY_SPLITTER = "pdfEditor.splitter";
    private final AppPreferences appPreferences;
    private final BackgroundRenderer backgroundRenderer;
    private final AppColorConfig colorConfig;
    private final UIUtils uiUtils;
    private final ActionService actionService;
    private JSplitPane splitter;
    private PageListView pageList;
    private PageView pageView;
    private PDDocument pdfDocument;
    private List<BufferedImage> pageImages;
    private int pageIndex;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.splitter = new JSplitPane(1);
        this.add((Component)this.splitter, "Center");
        this.pageList = new PageListView(this.colorConfig);
        this.splitter.setLeftComponent(this.pageList);
        this.pageView = new PageView(this.actionService, this.uiUtils, this.colorConfig);
        this.pageView.getPageSelectionListeners().add(this::onPageSelectedInView);
        this.splitter.setRightComponent(this.pageView);
        this.pageList.getPageSelectionListeners().add(this::onPageSelectedInList);
        this.pageList.getPageMoveListeners().add(this::onPageMoved);
        this.configureActions();
    }

    private void configureActions() {
        this.actionService.getAction(Actions.documentPageTurnLeft).setActionListener(l -> this.onTurn(-90));
        this.actionService.getAction(Actions.documentPageTurnRight).setActionListener(l -> this.onTurn(90));
        this.actionService.getAction(Actions.documentPageDelete).setActionListener(l -> this.onDelete());
    }

    private void onTurn(int rotation) {
        PDPage page = this.pdfDocument.getPage(this.pageIndex);
        page.setRotation(page.getRotation() + rotation);
        this.renderPage(this.pageIndex);
        this.pageView.loadDocument(this.pdfDocument, this.pageIndex + 1);
    }

    private void onDelete() {
        this.pdfDocument.removePage(this.pageIndex);
        this.pageImages.remove(this.pageIndex);
        if (this.pageIndex >= this.pdfDocument.getNumberOfPages()) {
            this.pageIndex = this.pdfDocument.getNumberOfPages() - 1;
        }
        this.pageView.loadDocument(this.pdfDocument, this.pageIndex + 1);
        this.pageList.updatePageImages(this.pageImages);
        this.updateActions();
    }

    private void onPageSelectedInList(int pageIndex) {
        this.pageIndex = pageIndex;
        this.pageView.loadDocument(this.pdfDocument, pageIndex + 1);
    }

    private void onPageSelectedInView(int pageIndex) {
        this.pageIndex = pageIndex - 1;
        this.pageList.markSelection(this.pageIndex);
    }

    public void initUI(File file) {
        this.initSplitter();
        this.loadDocument(file);
        this.renderPages();
    }

    private void loadDocument(File file) {
        try {
            this.pdfDocument = Loader.loadPDF((File)file);
            this.pageList.setPageCount(this.pdfDocument.getNumberOfPages());
            this.pageView.loadDocument(this.pdfDocument, this.pageIndex + 1);
            this.updateActions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void updateActions() {
        this.actionService.getAction(Actions.documentPageDelete).setEnabled(this.pdfDocument.getNumberOfPages() > 1);
    }

    public void renderPages() {
        this.backgroundRenderer.renderImages(this.pdfDocument).thenAccept(this::onPagesRendered);
    }

    private void renderPage(int pageIndex) {
        this.backgroundRenderer.renderImage(this.pdfDocument, pageIndex, this.pageImages).thenAccept(this::onPagesRendered);
    }

    private void onPagesRendered(List<BufferedImage> pageImages) {
        this.pageImages = pageImages;
        this.pageList.updatePageImages(pageImages);
    }

    private void initSplitter() {
        try {
            this.splitter.setDividerLocation(Integer.parseInt(this.appPreferences.get(PREF_KEY_SPLITTER)));
        }
        catch (Exception e) {
            this.splitter.setDividerLocation(400);
        }
    }

    public void storeProperties(Rectangle bounds) {
        this.appPreferences.put(PREF_KEY, new RectangleWrapper(bounds));
        this.appPreferences.put(PREF_KEY_SPLITTER, this.splitter.getDividerLocation());
    }

    private void onPageMoved(int sourceIndex, int targetIndex) {
        PDPage page = this.pdfDocument.getPages().get(sourceIndex);
        if (targetIndex < sourceIndex) {
            this.pdfDocument.getPages().remove(sourceIndex);
            this.pdfDocument.getPages().insertBefore(page, this.pdfDocument.getPages().get(targetIndex));
        } else {
            this.pdfDocument.getPages().insertAfter(page, this.pdfDocument.getPages().get(targetIndex));
            this.pdfDocument.getPages().remove(sourceIndex);
        }
        if (this.pageIndex >= this.pdfDocument.getNumberOfPages()) {
            --this.pageIndex;
        }
        this.pageView.loadDocument(this.pdfDocument, this.pageIndex);
        this.renderPages();
    }

    @Generated
    public PDFEditPanel(AppPreferences appPreferences, BackgroundRenderer backgroundRenderer, AppColorConfig colorConfig, UIUtils uiUtils, ActionService actionService) {
        this.appPreferences = appPreferences;
        this.backgroundRenderer = backgroundRenderer;
        this.colorConfig = colorConfig;
        this.uiUtils = uiUtils;
        this.actionService = actionService;
    }

    @Generated
    public PDDocument getPdfDocument() {
        return this.pdfDocument;
    }
}

