/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.pdfedit;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class BackgroundRenderer {
    @Async
    public CompletableFuture<List<BufferedImage>> renderImages(PDDocument pdfDocument) {
        ArrayList<BufferedImage> pageImages = new ArrayList<BufferedImage>();
        PDFRenderer renderer = new PDFRenderer(pdfDocument);
        for (int i = 0; i < pdfDocument.getNumberOfPages(); ++i) {
            try {
                BufferedImage image = renderer.renderImage(i);
                pageImages.add(image);
                continue;
            }
            catch (IOException e) {
                return CompletableFuture.failedFuture(e);
            }
        }
        return CompletableFuture.completedFuture(pageImages);
    }

    public CompletableFuture<List<BufferedImage>> renderImage(PDDocument pdfDocument, int pageIndex, List<BufferedImage> pageImages) {
        PDFRenderer renderer = new PDFRenderer(pdfDocument);
        try {
            BufferedImage image = renderer.renderImage(pageIndex);
            pageImages.set(pageIndex, image);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.completedFuture(pageImages);
    }
}

