/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.list.targetmenu;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import net.schembs.solutions.desktopclient.service.AppAction;
import net.schembs.solutions.dms.client.model.Tag;
import net.schembs.solutions.dms.client.ui.general.document.list.targetmenu.TargetMenuItem;
import net.schembs.solutions.dms.client.ui.general.tag.tree.DefaultTagTreeNode;

public class TargetMenu
extends JMenu {
    private final JPopupMenu rootPopupMenu;
    private final DefaultTagTreeNode tagTreeNode;
    private final AppAction action;
    private boolean isMenuCreated = false;

    public TargetMenu(JPopupMenu rootPopupMenu, DefaultTagTreeNode tagTreeNode, AppAction action) {
        super(tagTreeNode.getTag().getName());
        this.rootPopupMenu = rootPopupMenu;
        this.tagTreeNode = tagTreeNode;
        this.action = action;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TargetMenu.this.onClickMenu(e);
            }
        });
    }

    private void onClickMenu(MouseEvent e) {
        this.rootPopupMenu.setVisible(false);
        ActionEvent event = new ActionEvent(e.getSource(), 1001, this.tagTreeNode.getTag().getId());
        this.action.actionPerformed(event);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        this.populateIfNecessary();
        return super.getPopupMenu();
    }

    private void populateIfNecessary() {
        if (!this.isMenuCreated) {
            for (int i = 0; i < this.tagTreeNode.getChildCount(); ++i) {
                DefaultTagTreeNode child = this.tagTreeNode.getTagTreeNodeChildAt(i);
                if (!TargetMenu.isTargetTag(child.getTag())) continue;
                this.add(TargetMenu.hasNormalChildren(child) ? new TargetMenu(this.rootPopupMenu, child, this.action) : new TargetMenuItem(child, this.action));
            }
            this.isMenuCreated = true;
        }
    }

    public static boolean hasNormalChildren(DefaultTagTreeNode tagTreeNode) {
        for (int i = 0; i < tagTreeNode.getChildCount(); ++i) {
            DefaultTagTreeNode child = tagTreeNode.getTagTreeNodeChildAt(i);
            if (!TargetMenu.isTargetTag(child.getTag())) continue;
            return true;
        }
        return false;
    }

    public static boolean isTargetTag(Tag tag) {
        return !tag.isSearchResult() && !tag.isSearchResultsContainer() && !tag.isQuery();
    }
}

