/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.list;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import lombok.Generated;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTable;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableDragDropListener;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableModel;
import net.schembs.solutions.dms.client.ui.general.document.list.TaggedDMSDocumentTransferable;

public class DocumentTableTransferHandler
extends TransferHandler {
    private final DocumentTableDragDropListener dragDropListener;

    @Override
    protected Transferable createTransferable(JComponent c) {
        if (c instanceof DocumentTable) {
            DocumentTable table = (DocumentTable)c;
            DocumentTableModel model = (DocumentTableModel)table.getModel();
            List<DmsDocument> documentsTransfer = Arrays.stream(table.getSelectedModelRowIndices()).mapToObj(i -> (DmsDocument)model.getRows().get(i)).toList();
            if (documentsTransfer.getFirst().getResultType() != null) {
                return null;
            }
            TaggedDMSDocuments taggedDMSDocuments = TaggedDMSDocuments.builder().documents(documentsTransfer).build();
            this.dragDropListener.onDragDropStart(taggedDMSDocuments);
            return new TaggedDMSDocumentTransferable(taggedDMSDocuments);
        }
        return null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
            DocumentTable table = (DocumentTable)support.getComponent();
            try {
                TaggedDMSDocuments taggedDMSDocuments = (TaggedDMSDocuments)support.getTransferable().getTransferData(TaggedDMSDocumentTransferable.DATA_FLAVOR);
                table.onPastedDocuments(taggedDMSDocuments);
                return false;
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        return super.importData(support);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        if (data != null && data.isDataFlavorSupported(TaggedDMSDocumentTransferable.DATA_FLAVOR)) {
            try {
                TaggedDMSDocuments taggedDMSDocuments = (TaggedDMSDocuments)data.getTransferData(TaggedDMSDocumentTransferable.DATA_FLAVOR);
                if (taggedDMSDocuments.getTagToAdd() != null) {
                    this.dragDropListener.onDragDropEnd(taggedDMSDocuments, action);
                } else if (action == 1) {
                    taggedDMSDocuments.setTagToRemove(null);
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Generated
    public DocumentTableTransferHandler(DocumentTableDragDropListener dragDropListener) {
        this.dragDropListener = dragDropListener;
    }
}

