/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.list;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTable;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableDragDropListener;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableModel;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableTransferHandler;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentsPastedListener;

@org.springframework.stereotype.Component
public class DocumentTablePanel
extends JPanel
implements DocumentTableDragDropListener {
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final ColorConfig colorConfig;
    private final SettingsService<AppSettings> settingsService;
    private DocumentTable table;
    private final List<DocumentTableDragDropListener> dragDropListeners = new ArrayList<DocumentTableDragDropListener>();
    private final List<DocumentsPastedListener> documentsPastedListeners = new ArrayList<DocumentsPastedListener>();
    private JLabel documentCountLabel;
    private JLabel documentSelectedCountLabel;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new DocumentTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        this.table.setDragEnabled(true);
        this.table.setTransferHandler(new DocumentTableTransferHandler(this));
        this.table.setDocumentsPastedListener(this::onDocumentsPasted);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        JPanel infoPanel = new JPanel(new FlowLayout(0, 5, 1));
        this.add((Component)infoPanel, "South");
        this.documentCountLabel = new JLabel(this.i18n.t("documentTable.documents.count", 0));
        infoPanel.add(this.documentCountLabel);
        infoPanel.add(new JLabel("|"));
        this.documentSelectedCountLabel = new JLabel(this.i18n.t("documentTable.documents.selected.count", 0));
        infoPanel.add(this.documentSelectedCountLabel);
    }

    public void setModel(DocumentTableModel model) {
        this.table.setModel(model);
    }

    public void selectRow(int row) {
        if (row >= this.table.getRowCount()) {
            row = this.table.getRowCount() - 1;
        }
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    @Override
    public void onDragDropStart(TaggedDMSDocuments taggedDMSDocuments) {
        this.dragDropListeners.forEach(l -> l.onDragDropStart(taggedDMSDocuments));
    }

    @Override
    public void onDragDropEnd(TaggedDMSDocuments taggedDMSDocuments, int action) {
        this.dragDropListeners.forEach(l -> l.onDragDropEnd(taggedDMSDocuments, action));
    }

    private void onDocumentsPasted(TaggedDMSDocuments taggedDMSDocuments) {
        this.documentsPastedListeners.forEach(l -> l.onPastedDocuments(taggedDMSDocuments));
    }

    public void updateTableTypeForSearchResults(boolean withSearchFields) {
        this.table.updateTableType(withSearchFields ? DocumentTable.TableType.searchResults : DocumentTable.TableType.documents);
    }

    @Generated
    public DocumentTablePanel(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
    }

    @Generated
    public DocumentTable getTable() {
        return this.table;
    }

    @Generated
    public List<DocumentTableDragDropListener> getDragDropListeners() {
        return this.dragDropListeners;
    }

    @Generated
    public List<DocumentsPastedListener> getDocumentsPastedListeners() {
        return this.documentsPastedListeners;
    }

    @Generated
    public JLabel getDocumentCountLabel() {
        return this.documentCountLabel;
    }

    @Generated
    public JLabel getDocumentSelectedCountLabel() {
        return this.documentSelectedCountLabel;
    }
}

