/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.list;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentStatus;
import net.schembs.solutions.dms.client.model.SearchResultType;

public class DocumentTableModel
extends AbstractXTableModel<DmsDocument> {
    private boolean showSearchFields = false;

    public DocumentTableModel(I18nService i18n) {
        super(i18n);
    }

    @Override
    public int getColumnCount() {
        return this.showSearchFields ? 7 : 5;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return switch (columnIndex) {
                case 0 -> ((DmsDocument)this.rows.get(rowIndex)).getId();
                case 1 -> this.getDescription(rowIndex);
                case 2 -> ((DmsDocument)this.rows.get(rowIndex)).getDocumentDate();
                case 3 -> ((DmsDocument)this.rows.get(rowIndex)).getStatus();
                case 4 -> ((DmsDocument)this.rows.get(rowIndex)).getAssignee();
                case 5 -> ((DmsDocument)this.rows.get(rowIndex)).getResultType();
                case 6 -> ((DmsDocument)this.rows.get(rowIndex)).getResult();
                default -> "Unknown";
            };
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    private String getDescription(int rowIndex) {
        String description = ((DmsDocument)this.rows.get(rowIndex)).getDescription();
        return description != null && !description.trim().isEmpty() ? description : "(" + ((DmsDocument)this.rows.get(rowIndex)).getName() + ")";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0 -> Long.class;
            case 2 -> LocalDate.class;
            case 3 -> DocumentStatus.class;
            case 5 -> SearchResultType.class;
            default -> super.getColumnClass(columnIndex);
        };
    }

    @Override
    public String getTableId() {
        return "documentTable";
    }

    @Override
    public TableColumnModel getDefaultTableColumnModel() {
        return TableColumnModel.builder().columnWidths(new int[]{40, 450, 150, 50, 100, 100, 100}).build();
    }

    @Override
    public List<String> getColumnTitles() {
        return List.of("document.id", "document.description", "document.date", "document.status", "document.assignee", "document.resultType", "document.result");
    }

    @Generated
    public void setShowSearchFields(boolean showSearchFields) {
        this.showSearchFields = showSearchFields;
    }
}

