/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.list;

import java.time.LocalDate;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.general.xtable.XTable;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.DateTimeFormat;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentStatus;
import net.schembs.solutions.dms.client.model.SearchResultType;
import net.schembs.solutions.dms.client.model.TaggedDMSDocuments;
import net.schembs.solutions.dms.client.ui.general.DateTimeCellrenderer;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentStatusCellRenderer;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentTableModel;
import net.schembs.solutions.dms.client.ui.general.document.list.DocumentsPastedListener;
import net.schembs.solutions.dms.client.ui.general.document.list.SearchResultTypeCellRenderer;

public class DocumentTable
extends XTable<DmsDocument> {
    private DocumentsPastedListener documentsPastedListener;

    public DocumentTable(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<AppSettings> settingsService) {
        super(i18n, appPreferences, colorConfig, settingsService);
        this.setDefaultRenderer(LocalDate.class, new DateTimeCellrenderer(i18n, DateTimeFormat.dmy));
        this.setDefaultRenderer(DocumentStatus.class, new DocumentStatusCellRenderer(i18n));
        this.setDefaultRenderer(SearchResultType.class, new SearchResultTypeCellRenderer(i18n));
        this.getSelectionModel().setSelectionMode(2);
    }

    public void onPastedDocuments(TaggedDMSDocuments taggedDMSDocuments) {
        if (this.documentsPastedListener != null) {
            this.documentsPastedListener.onPastedDocuments(taggedDMSDocuments);
        }
    }

    public void updateTableType(TableType tableType) {
        if (tableType == TableType.documents) {
            this.setColumnVisible(5, false);
            this.setColumnVisible(6, false);
            ((DocumentTableModel)this.getTableModel()).setShowSearchFields(false);
        } else if (tableType == TableType.searchResults) {
            this.setColumnVisible(5, true);
            this.setColumnVisible(6, true);
            ((DocumentTableModel)this.getTableModel()).setShowSearchFields(true);
        }
    }

    @Generated
    public void setDocumentsPastedListener(DocumentsPastedListener documentsPastedListener) {
        this.documentsPastedListener = documentsPastedListener;
    }

    public static enum TableType {
        documents,
        searchResults;

    }
}

