/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.edit.content;

import java.util.List;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.dms.client.model.DocumentWord;

public class DocumentContentTableModel
extends AbstractXTableModel<DocumentWord> {
    public DocumentContentTableModel(I18nService i18n) {
        super(i18n);
    }

    @Override
    public String getTableId() {
        return "documentContentTable";
    }

    @Override
    public TableColumnModel getDefaultTableColumnModel() {
        return TableColumnModel.builder().columnWidths(new int[]{400, 200, 200}).build();
    }

    @Override
    public List<String> getColumnTitles() {
        return List.of("document.content.word", "document.content.value", "document.content.weight");
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> ((DocumentWord)this.rows.get(rowIndex)).getWord();
            case 1 -> ((DocumentWord)this.rows.get(rowIndex)).getValue();
            case 2 -> ((DocumentWord)this.rows.get(rowIndex)).getWeight();
            default -> null;
        };
    }

    public void setContent(List<DocumentWord> documentWords) {
        this.rows.clear();
        this.rows.addAll(documentWords);
    }
}

