/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.edit.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.controller.AnalyzedDocumentLoader;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.DocumentWord;
import net.schembs.solutions.dms.client.ui.general.document.edit.content.DocumentContentTable;
import net.schembs.solutions.dms.client.ui.general.document.edit.content.DocumentContentTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentContentEditor
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentContentEditor.class);
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final AppColorConfig colorConfig;
    private final SettingsService<AppSettings> settingsService;
    private DocumentContentTable table;
    private DocumentContentTableModel contentTableModel;
    private AnalyzedDocumentLoader contentLoader;

    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new DocumentContentTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        this.contentTableModel = new DocumentContentTableModel(this.i18n);
        this.table.setModel(this.contentTableModel);
    }

    public void onEditorSelected() {
        this.populateModel();
    }

    private void populateModel() {
        log.info("Loading content");
        this.contentLoader.loadAnalyzedDocumentContent(this::onContentLoaded);
    }

    private void onContentLoaded(List<DocumentWord> documentWords) {
        this.contentTableModel.setContent(documentWords);
        this.contentTableModel.fireTableDataChanged();
    }

    @Generated
    public DocumentContentEditor(I18nService i18n, AppPreferences appPreferences, AppColorConfig colorConfig, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
    }

    @Generated
    public void setContentLoader(AnalyzedDocumentLoader contentLoader) {
        this.contentLoader = contentLoader;
    }
}

