/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.edit;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.DateFormatter;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.DateTimeFormat;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentAttribute;
import net.schembs.solutions.dms.client.model.DocumentStatus;
import net.schembs.solutions.dms.client.model.DocumentStatusComboItem;
import net.schembs.solutions.dms.client.ui.general.AutoCompleteTextField;
import net.schembs.solutions.dms.client.ui.general.document.edit.ReadOnlyField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentMetadataEditor
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentMetadataEditor.class);
    private final I18nService i18n;
    private final AppColorConfig colorConfig;
    private JLabel lblId;
    private AutoCompleteTextField txtDescription;
    private JFormattedTextField txtDate;
    private DateTimeFormatter dateFormatter;
    private JComboBox<DocumentStatusComboItem> cmbStatus;
    private JTextField txtOwner;
    private JTextField txtAssignee;

    public void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.setLayout(new VerticalLayout(2));
        this.add(new JLabel(this.i18n.t("document.id", new Object[0])));
        this.lblId = new ReadOnlyField(this.colorConfig);
        this.add(this.lblId);
        this.add(new JLabel(this.i18n.t("document.description", new Object[0])));
        this.txtDescription = new AutoCompleteTextField();
        this.add(this.txtDescription);
        this.add(new JLabel(this.i18n.t("document.date", new Object[0])));
        this.dateFormatter = DateTimeFormatter.ofPattern(this.i18n.t(DateTimeFormat.dmy.toString(), new Object[0]));
        DateFormatter formatter = new DateFormatter(new SimpleDateFormat(this.i18n.t(DateTimeFormat.dmy.toString(), new Object[0])));
        formatter.setAllowsInvalid(false);
        formatter.setOverwriteMode(true);
        this.txtDate = new JFormattedTextField(formatter);
        this.add(this.txtDate);
        this.add(new JLabel(this.i18n.t("document.status", new Object[0])));
        this.cmbStatus = new JComboBox<DocumentStatusComboItem>((DocumentStatusComboItem[])Arrays.stream(DocumentStatus.values()).map(s -> DocumentStatusComboItem.builder().status((DocumentStatus)((Object)s)).label(this.i18n.t("status." + s.toString(), new Object[0])).build()).toArray(DocumentStatusComboItem[]::new));
        this.add(this.cmbStatus);
        this.add(new JLabel(this.i18n.t("document.owner", new Object[0])));
        this.txtOwner = new JTextField();
        this.add(this.txtOwner);
        this.add(new JLabel(this.i18n.t("document.assignee", new Object[0])));
        this.txtAssignee = new JTextField();
        this.add(this.txtAssignee);
    }

    public JComponent initUI(DmsDocument document, DocumentAttribute attribute, List<String> existingDescriptions) {
        log.info("Select attribute {} of {}", (Object)attribute, (Object)document);
        this.lblId.setText(document.getId().toString());
        this.txtDescription.setCompletions(existingDescriptions);
        this.txtDescription.setText(document.getDescription());
        this.txtDate.setText(this.dateFormatter.format(document.getDocumentDate()));
        this.cmbStatus.setSelectedIndex(document.getStatus().ordinal());
        this.txtOwner.setText(document.getOwner());
        this.txtAssignee.setText(document.getAssignee());
        JComponent componentToFocus = this.txtDescription;
        if (attribute != null && attribute.getKey() != null) {
            componentToFocus = switch (attribute.getKey()) {
                case "document.date" -> this.txtDate;
                case "document.status" -> this.cmbStatus;
                case "document.assignee" -> this.txtAssignee;
                case "document.owner" -> this.txtOwner;
                default -> this.txtDescription;
            };
        }
        return componentToFocus;
    }

    public void applyToDocument(DmsDocument document) {
        document.setDescription(this.txtDescription.getText());
        document.setAssignee(this.txtAssignee.getText());
        document.setOwner(this.txtOwner.getText());
        document.setStatus(((DocumentStatusComboItem)this.cmbStatus.getSelectedItem()).getStatus());
        TemporalAccessor temporalAccessor = this.dateFormatter.parse(this.txtDate.getText());
        LocalDate localDateTime = LocalDate.from(temporalAccessor);
        document.setDocumentDate(localDateTime);
    }

    @Generated
    public DocumentMetadataEditor(I18nService i18n, AppColorConfig colorConfig) {
        this.i18n = i18n;
        this.colorConfig = colorConfig;
    }
}

