/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.edit;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.controller.AnalyzedDocumentLoader;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentAttribute;
import net.schembs.solutions.dms.client.ui.general.document.edit.DocumentMetadataEditor;
import net.schembs.solutions.dms.client.ui.general.document.edit.content.DocumentContentEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class DocumentEditPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentEditPanel.class);
    private final I18nService i18n;
    private final AppColorConfig colorConfig;
    private final AppPreferences appPreferences;
    private final SettingsService<AppSettings> settingsService;
    private DocumentMetadataEditor documentMetadataEditor;
    private DocumentContentEditor documentContentEditor;
    private JTabbedPane tabbedPane;

    @PostConstruct
    public void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        this.setLayout(new BorderLayout());
        this.documentMetadataEditor = new DocumentMetadataEditor(this.i18n, this.colorConfig);
        this.documentMetadataEditor.createUI();
        this.documentContentEditor = new DocumentContentEditor(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        this.documentContentEditor.createUI();
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.add(this.i18n.t("document.edit.metadata", new Object[0]), this.documentMetadataEditor);
        this.tabbedPane.add(this.i18n.t("document.edit.content", new Object[0]), this.documentContentEditor);
        this.tabbedPane.addChangeListener(e -> this.onTabSelected(this.tabbedPane.getSelectedIndex()));
        this.add((Component)this.tabbedPane, "Center");
    }

    public void initUI(DmsDocument document, DocumentAttribute attribute, List<String> existingDescriptions) {
        JComponent componentToFocus = this.documentMetadataEditor.initUI(document, attribute, existingDescriptions);
        this.tabbedPane.setSelectedIndex(0);
        SwingUtilities.invokeLater(componentToFocus::requestFocus);
    }

    public void applyToDocument(DmsDocument document) {
        this.documentMetadataEditor.applyToDocument(document);
    }

    private void onTabSelected(int selectedIndex) {
        if (selectedIndex == 1) {
            this.documentContentEditor.onEditorSelected();
        }
    }

    public void setContentLoader(AnalyzedDocumentLoader analyzedDocumentLoader) {
        this.documentContentEditor.setContentLoader(analyzedDocumentLoader);
    }

    @Generated
    public DocumentEditPanel(I18nService i18n, AppColorConfig colorConfig, AppPreferences appPreferences, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.colorConfig = colorConfig;
        this.appPreferences = appPreferences;
        this.settingsService = settingsService;
    }
}

