/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.drop;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropStatus;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTable;

public class DropUploadButtonCellEditor
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer {
    private final JPanel mainPanel;
    private final JButton button;
    private final JLabel noUploadButtonLabel;
    private final I18nService i18n;
    private final JPanel componentPanel;
    private final JButton xButton;
    private int currentRow = -1;
    private DropTable dropTable;
    private final AppColorConfig colorConfig;

    public DropUploadButtonCellEditor(I18nService i18n, AppColorConfig colorConfig) {
        this.i18n = i18n;
        this.colorConfig = colorConfig;
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add(Box.createHorizontalStrut(20), "West");
        this.mainPanel.add(Box.createHorizontalStrut(20), "East");
        this.componentPanel = new JPanel(new BorderLayout());
        this.componentPanel.setOpaque(false);
        this.mainPanel.add((Component)this.componentPanel, "Center");
        this.button = new JButton(i18n.t("dropTable.button.upload", new Object[0]));
        this.button.setFocusable(false);
        this.button.addActionListener(e -> {
            this.dropTable.onRowUpload(this.currentRow);
            this.fireEditingStopped();
        });
        this.noUploadButtonLabel = new JLabel();
        this.noUploadButtonLabel.setHorizontalAlignment(0);
        this.noUploadButtonLabel.setOpaque(false);
        this.xButton = new JButton("X");
        this.xButton.setFocusable(false);
        this.xButton.addActionListener(e -> {
            this.dropTable.onRowCanceled(this.currentRow);
            this.fireEditingStopped();
        });
        this.componentPanel.add((Component)this.xButton, "East");
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.configureComponent(table, isSelected, (DropStatus)((Object)value));
        return this.mainPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.dropTable = (DropTable)table;
        this.currentRow = row;
        this.configureComponent(table, true, (DropStatus)((Object)value));
        return this.mainPanel;
    }

    private void configureComponent(JTable table, boolean isSelected, DropStatus status) {
        this.xButton.setVisible(status != DropStatus.uploading);
        if (status == DropStatus.dropped) {
            this.componentPanel.remove(this.noUploadButtonLabel);
            this.componentPanel.add((Component)this.button, "Center");
        } else {
            this.componentPanel.remove(this.button);
            this.componentPanel.add((Component)this.noUploadButtonLabel, "Center");
            this.noUploadButtonLabel.setText(this.i18n.t("dropTable.status." + status.name(), new Object[0]));
        }
        this.mainPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        this.noUploadButtonLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        this.button.setBackground(isSelected ? this.colorConfig.getTableButtonSelectedBackground() : this.colorConfig.getTableButtonBackground());
        this.button.setForeground(isSelected ? this.colorConfig.getTableButtonSelectedForeground() : this.colorConfig.getTableButtonForeground());
        this.xButton.setBackground(isSelected ? this.colorConfig.getTableButtonSelectedBackground() : this.colorConfig.getTableButtonBackground());
        this.xButton.setForeground(isSelected ? this.colorConfig.getTableButtonSelectedForeground() : this.colorConfig.getTableButtonForeground());
    }
}

