/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.drop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import lombok.Generated;
import net.schembs.solutions.dms.client.ui.general.document.drop.DocumentDropListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTableTransferHandler
extends TransferHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DropTableTransferHandler.class);
    final List<DocumentDropListener> dropListeners;

    @Override
    public boolean importData(JComponent comp, Transferable transferable) {
        DataFlavor[] flavors;
        log.info("DropTableTransferHandler can import files");
        for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
            try {
                if (!flavor.isFlavorJavaFileListType()) continue;
                List files = (List)transferable.getTransferData(flavor);
                this.dropListeners.forEach(listener -> listener.onDrop(files));
                return true;
            }
            catch (UnsupportedFlavorException | IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return super.importData(comp, transferable);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return true;
        }
        return super.canImport(support);
    }

    @Generated
    public DropTableTransferHandler(List<DocumentDropListener> dropListeners) {
        this.dropListeners = dropListeners;
    }
}

