/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.drop;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.AppAction;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.ui.general.document.drop.DocumentDropListener;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropRowUploadListener;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTable;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableModel;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableTransferHandler;

@org.springframework.stereotype.Component
public class DropTablePanel
extends JPanel {
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final AppColorConfig colorConfig;
    private final ActionService actionService;
    private final SettingsService<AppSettings> settingsService;
    private DropTable table;
    private final List<DocumentDropListener> dropListeners = new ArrayList<DocumentDropListener>();

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new DropTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService, this.actionService);
        this.table.setTransferHandler(new DropTableTransferHandler(this.dropListeners));
        this.table.setFillsViewportHeight(true);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        this.reconfigureDeleteAction();
    }

    private void reconfigureDeleteAction() {
        AppAction action = this.actionService.getAction(Actions.documentMoveToTrash);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.table.getInputMap().put(keyStroke, "localDelete");
        this.table.getActionMap().put("localDelete", this.actionService.getAction(Actions.dropTableRemoveRow));
    }

    public void setModel(DropTableModel model) {
        this.table.setModel(model);
    }

    public int[] getSelectedRows() {
        return this.table.getSelectedRows();
    }

    public void selectRows(int[] index) {
        this.table.getSelectionModel().clearSelection();
        for (int i = 0; i < index.length; ++i) {
            this.table.getSelectionModel().addSelectionInterval(index[i], index[i]);
        }
    }

    public void setRowUploadListener(DropRowUploadListener listener) {
        this.table.setDropRowUploadListener(listener);
    }

    @Generated
    public DropTablePanel(I18nService i18n, AppPreferences appPreferences, AppColorConfig colorConfig, ActionService actionService, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.actionService = actionService;
        this.settingsService = settingsService;
    }

    @Generated
    public DropTable getTable() {
        return this.table;
    }

    @Generated
    public List<DocumentDropListener> getDropListeners() {
        return this.dropListeners;
    }
}

