/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.drop;

import java.util.List;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.general.xtable.AbstractXTableModel;
import net.schembs.solutions.desktopclient.ui.general.xtable.TableColumnModel;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropStatus;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableRow;

public class DropTableModel
extends AbstractXTableModel<DropTableRow> {
    public DropTableModel(I18nService i18n) {
        super(i18n);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            DropTableRow row = (DropTableRow)this.rows.get(rowIndex);
            return switch (columnIndex) {
                case 0 -> row.getFile().getName();
                case 1 -> row.getDescription();
                case 2 -> row.getType();
                case 3 -> row.getStatus();
                default -> null;
            };
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    @Override
    public List<String> getColumnTitles() {
        return List.of("dropTable.title.filename", "dropTable.title.description", "dropTable.title.type", "dropTable.title.status");
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        DropTableRow row = (DropTableRow)this.rows.get(rowIndex);
        if (row.getStatus() != DropStatus.uploading) {
            return switch (columnIndex) {
                case 3 -> true;
                default -> false;
            };
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 3 -> DropStatus.class;
            default -> super.getColumnClass(columnIndex);
        };
    }

    @Override
    public String getTableId() {
        return "dropTable";
    }

    @Override
    public TableColumnModel getDefaultTableColumnModel() {
        return TableColumnModel.builder().columnWidths(new int[]{400, 400, 50, 100}).build();
    }
}

