/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.document.drop;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.ActionService;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.general.xtable.XTable;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropRowUploadListener;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropStatus;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropTableRow;
import net.schembs.solutions.dms.client.ui.general.document.drop.DropUploadButtonCellEditor;

public class DropTable
extends XTable<DropTableRow> {
    private final AppColorConfig colorConfig;
    private DropRowUploadListener dropRowUploadListener;

    public DropTable(I18nService i18n, AppPreferences appPreferences, AppColorConfig colorConfig, SettingsService<AppSettings> settingsService, ActionService actionService) {
        super(i18n, appPreferences, colorConfig, settingsService);
        this.colorConfig = colorConfig;
        DropUploadButtonCellEditor buttonCellEditor = new DropUploadButtonCellEditor(i18n, colorConfig);
        DropUploadButtonCellEditor buttonCellRenderer = new DropUploadButtonCellEditor(i18n, colorConfig);
        this.setDefaultRenderer(DropStatus.class, buttonCellRenderer);
        this.setDefaultEditor(DropStatus.class, buttonCellEditor);
        this.getSelectionModel().setSelectionMode(2);
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getRowCount() == 0) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setPaint(this.colorConfig.getDropTargetForeground());
            int h = this.getHeight() - 20;
            double fontSize = 72.0 * (double)h / (double)Toolkit.getDefaultToolkit().getScreenResolution();
            g2d.setFont(this.getFont().deriveFont((float)fontSize));
            FontMetrics fm = g2d.getFontMetrics();
            int y = fm.getHeight() - fm.getDescent();
            String s = this.getI18n().t("dropTable.background.message", new Object[0]);
            int x = (this.getWidth() - fm.stringWidth(s)) / 2;
            g2d.drawString(s, x, y);
        }
    }

    public void onRowUpload(int row) {
        if (this.dropRowUploadListener != null) {
            this.dropRowUploadListener.onRowUploadPressed(this.getModelRowIndex(row));
        }
    }

    public void onRowCanceled(int row) {
        if (this.dropRowUploadListener != null) {
            this.dropRowUploadListener.onRowUploadCancelled(this.getModelRowIndex(row));
        }
    }

    @Generated
    public void setDropRowUploadListener(DropRowUploadListener dropRowUploadListener) {
        this.dropRowUploadListener = dropRowUploadListener;
    }
}

