/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.admin;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.config.ColorConfig;
import net.schembs.solutions.desktopclient.service.ComponentHelper;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.ui.general.TableRowSelectionListener;
import net.schembs.solutions.dms.client.ui.general.admin.UserTable;
import net.schembs.solutions.dms.client.ui.general.admin.UserTableModel;

@org.springframework.stereotype.Component
public class UserTablePanel
extends JPanel {
    private final I18nService i18n;
    private final AppPreferences appPreferences;
    private final ColorConfig colorConfig;
    private final SettingsService<AppSettings> settingsService;
    private UserTable table;
    private final List<TableRowSelectionListener> selectionListeners = new ArrayList<TableRowSelectionListener>();
    private Runnable onAdd;
    private JButton cmdAdd;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.table = new UserTable(this.i18n, this.appPreferences, this.colorConfig, this.settingsService);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        this.table.getListSelectionListeners().add(this::onSelect);
        JPanel btnPanel = new JPanel(new FlowLayout(3));
        this.cmdAdd = new JButton("+");
        this.cmdAdd.addActionListener(e -> this.onAddUser());
        btnPanel.add(this.cmdAdd);
        this.add((Component)btnPanel, "South");
        ComponentHelper.registerClose(this.table, this.cmdAdd);
        KeyboardHelper.registerActionOnComponent((JComponent)this.table, "cmd down", this.cmdAdd::requestFocus);
        KeyboardHelper.registerActionOnComponent((JComponent)this.cmdAdd, "cmd up", this.table::requestFocus);
    }

    private void onSelect(int[] rows) {
        this.selectionListeners.forEach(l -> l.onSelectRow(rows));
    }

    public void setModel(UserTableModel userTableModel) {
        this.table.setModel(userTableModel);
    }

    public void selectRow(int row) {
        if (row >= this.table.getRowCount()) {
            row = this.table.getRowCount() - 1;
        }
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    public void selectModelRow(int modelRow) {
        int row = this.table.convertRowIndexToView(modelRow);
        if (row >= this.table.getRowCount()) {
            row = this.table.getRowCount() - 1;
        }
        this.table.getSelectionModel().setSelectionInterval(row, row);
    }

    private void onAddUser() {
        if (this.onAdd != null) {
            this.onAdd.run();
        }
    }

    @Override
    public void requestFocus() {
        this.table.requestFocus();
    }

    public void setRightComponent(JComponent component) {
        KeyboardHelper.registerActionOnComponent((JComponent)this.table, "cmd right", component::requestFocus);
        KeyboardHelper.registerActionOnComponent((JComponent)this.cmdAdd, "cmd right", component::requestFocus);
    }

    @Generated
    public UserTablePanel(I18nService i18n, AppPreferences appPreferences, ColorConfig colorConfig, SettingsService<AppSettings> settingsService) {
        this.i18n = i18n;
        this.appPreferences = appPreferences;
        this.colorConfig = colorConfig;
        this.settingsService = settingsService;
    }

    @Generated
    public List<TableRowSelectionListener> getSelectionListeners() {
        return this.selectionListeners;
    }

    @Generated
    public void setOnAdd(Runnable onAdd) {
        this.onAdd = onAdd;
    }
}

