/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general.admin;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.KeyboardFocusManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.KeyboardHelper;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.model.DmsUser;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.ui.general.ChangeDetector;
import net.schembs.solutions.dms.client.ui.general.ErrorText;
import net.schembs.solutions.dms.security.model.DmsPermission;
import net.schembs.solutions.dms.security.model.SystemPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@org.springframework.stereotype.Component
public class UserEditorPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserEditorPanel.class);
    private final AppColorConfig colorConfig;
    private JTextField txtUsername;
    private JTextField txtFullname;
    private JPasswordField txtPassword;
    private JPasswordField txtPasswordRepeat;
    private final I18nService i18n;
    Map<String, JCheckBox> systemPermissionCheckboxes = new HashMap<String, JCheckBox>();
    Map<String, JCheckBox> clientPermissionCheckboxes = new HashMap<String, JCheckBox>();
    private final ChangeDetector changeDetector = new ChangeDetector();
    private JButton saveButton;
    private JButton resetButton;
    private DmsUser currentUser;
    private boolean changed = false;
    private Consumer<DmsUser> onSave;
    private Consumer<DmsUser> onCancelNew;
    private boolean settingUser = false;
    private boolean onChangeProcessing = false;
    private List<String> userNameList;
    private JPanel errorPanel;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        JPanel holder = new JPanel();
        JScrollPane scrollPane = new JScrollPane(holder);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        holder.setBorder(BorderFactory.createEmptyBorder(5, 20, 5, 20));
        holder.setLayout(new VerticalLayout(2));
        holder.add(new JLabel(this.i18n.t("admin.user.name", new Object[0])));
        this.txtUsername = new JTextField();
        holder.add(this.txtUsername);
        this.changeDetector.applyTo(this.txtUsername);
        holder.add(new JLabel(this.i18n.t("admin.user.fullname", new Object[0])));
        this.txtFullname = new JTextField();
        holder.add(this.txtFullname);
        this.changeDetector.applyTo(this.txtFullname);
        holder.add(new JLabel(this.i18n.t("admin.user.password.new", new Object[0])));
        this.txtPassword = new JPasswordField();
        holder.add(this.txtPassword);
        this.changeDetector.applyTo(this.txtPassword);
        holder.add(new JLabel(this.i18n.t("admin.user.password.repeat", new Object[0])));
        this.txtPasswordRepeat = new JPasswordField();
        holder.add(this.txtPasswordRepeat);
        this.changeDetector.applyTo(this.txtPasswordRepeat);
        holder.add(Box.createVerticalStrut(10));
        JPanel dmsPermissionHolder = new JPanel(new VerticalLayout(2));
        dmsPermissionHolder.add(new JLabel(this.i18n.t("admin.user.permission.system.title", new Object[0])));
        dmsPermissionHolder.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.colorConfig.getBorderColor()), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        JPanel dmsSystemPermissionsPanel = new JPanel(new FlowLayout(0));
        dmsPermissionHolder.add(dmsSystemPermissionsPanel);
        for (SystemPermission systemPermission : SystemPermission.values()) {
            JCheckBox cbPermission = new JCheckBox(this.i18n.t(systemPermission.toString(), new Object[0]));
            dmsSystemPermissionsPanel.add(cbPermission);
            this.systemPermissionCheckboxes.put(systemPermission.getRoleName(), cbPermission);
            this.changeDetector.applyTo(cbPermission);
        }
        holder.add(dmsPermissionHolder);
        holder.add(Box.createVerticalStrut(10));
        JPanel clientHolder = new JPanel(new VerticalLayout(2));
        JPanel clientPanel = new JPanel(new VerticalLayout(2));
        clientPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(this.colorConfig.getBorderColor()), BorderFactory.createEmptyBorder(5, 10, 5, 10)));
        clientPanel.add(new JLabel(this.i18n.t("admin.user.permission.dms.title", new Object[0])));
        JPanel permissionsPanel = new JPanel(new FlowLayout(0));
        for (DmsPermission p : DmsPermission.values()) {
            JCheckBox cbPermission = new JCheckBox(this.i18n.t(p.toString(), new Object[0]));
            this.clientPermissionCheckboxes.put(p.getRoleName(), cbPermission);
            permissionsPanel.add(cbPermission);
            this.changeDetector.applyTo(cbPermission);
        }
        clientPanel.add(permissionsPanel);
        clientHolder.add(clientPanel);
        clientHolder.add(Box.createVerticalStrut(10));
        holder.add(clientHolder);
        this.errorPanel = new JPanel(new VerticalLayout(2));
        holder.add(this.errorPanel);
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.saveButton = new JButton(this.i18n.t("button.save", new Object[0]));
        this.saveButton.addActionListener(e -> this.onSave());
        this.resetButton = new JButton(this.i18n.t("button.reset", new Object[0]));
        this.resetButton.addActionListener(e -> this.onReset());
        jPanel.add(this.saveButton);
        jPanel.add(this.resetButton);
        this.add((Component)jPanel, "South");
        this.changeDetector.getChangeListeners().add(this::onChanged);
        this.onChanged(false);
        this.registerUpDown(this.txtUsername, false, true);
        this.registerUpDown(this.txtFullname, true, true);
        this.registerUpDown(this.txtPassword, true, true);
        this.registerUpDown(this.txtPasswordRepeat, true, true);
    }

    public void onSave() {
        if (this.onSave != null) {
            this.onSave.accept(DmsUser.builder().newUser(this.currentUser.isNewUser()).username(this.txtUsername.getText()).fullName(this.txtFullname.getText()).password(new String(this.txtPassword.getPassword())).roles(this.captureRoles()).build());
            this.onChanged(false);
        }
    }

    private List<String> captureRoles() {
        ArrayList<String> roles = new ArrayList<String>(this.systemPermissionCheckboxes.entrySet().stream().filter(p -> ((JCheckBox)p.getValue()).isSelected()).map(Map.Entry::getKey).toList());
        roles.addAll(this.clientPermissionCheckboxes.entrySet().stream().filter(p -> ((JCheckBox)p.getValue()).isSelected()).map(Map.Entry::getKey).toList());
        return roles;
    }

    public void onReset() {
        if (this.currentUser.isNewUser()) {
            if (this.onCancelNew != null) {
                this.changed = false;
                this.onCancelNew.accept(this.currentUser);
            }
        } else {
            this.setUser(this.currentUser);
        }
    }

    public void onChanged(boolean b) {
        if (!this.settingUser && !this.onChangeProcessing) {
            try {
                this.onChangeProcessing = true;
                boolean userIsValid = this.isUserValid();
                this.saveButton.setEnabled(b && userIsValid);
                this.resetButton.setEnabled(b);
                this.changed = b;
                if (!b) {
                    this.txtPassword.setText("");
                    this.txtPasswordRepeat.setText("");
                }
            }
            finally {
                this.onChangeProcessing = false;
            }
        }
    }

    public boolean isUserValid() {
        this.errorPanel.removeAll();
        boolean result = this.isUserNameValid() && this.isPasswordFieldsValid();
        this.errorPanel.revalidate();
        return result;
    }

    private boolean isUserNameValid() {
        boolean comparison;
        boolean result;
        String userName = this.txtUsername.getText() != null ? this.txtUsername.getText().trim() : "";
        boolean bl = result = !userName.isEmpty();
        if (!result) {
            this.errorPanel.add(new ErrorText(this.i18n.t(ErrorCode.adminUsernameMustNotBeEmpty.toString(), new Object[0])));
        }
        boolean bl2 = comparison = this.userNameList == null || !this.userNameList.contains(userName.toLowerCase()) || !this.isNewUser() && userName.equals(this.currentUser.getUsername());
        if (!comparison) {
            this.errorPanel.add(new ErrorText(this.i18n.t(ErrorCode.adminUsernameAlreadyExists.toString(), new Object[0])));
        }
        return result && comparison;
    }

    private boolean isPasswordFieldsValid() {
        String passwordRepeat;
        String password = this.txtPassword.getPassword() != null ? new String(this.txtPassword.getPassword()).trim() : "";
        String string = passwordRepeat = this.txtPasswordRepeat.getPassword() != null ? new String(this.txtPasswordRepeat.getPassword()).trim() : "";
        if (this.currentUser == null || !this.currentUser.isNewUser() && password.isEmpty() && passwordRepeat.isEmpty()) {
            return true;
        }
        boolean result = true;
        if (password.length() < 8) {
            this.errorPanel.add(new ErrorText(this.i18n.t(ErrorCode.adminPasswordIsToShort.toString(), new Object[0])));
            result = false;
        }
        if (!password.equals(passwordRepeat)) {
            this.errorPanel.add(new ErrorText(this.i18n.t(ErrorCode.adminPasswordsDontMatch.toString(), new Object[0])));
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUser(DmsUser user) {
        try {
            this.settingUser = true;
            for (JCheckBox cbPermission : this.systemPermissionCheckboxes.values()) {
                cbPermission.setSelected(false);
            }
            for (JCheckBox cbPermission : this.clientPermissionCheckboxes.values()) {
                cbPermission.setSelected(false);
            }
            if (user != null) {
                this.txtUsername.setText(user.getUsername());
                this.txtFullname.setText(user.getFullName());
                for (String role : user.getRoles()) {
                    JCheckBox cb = this.systemPermissionCheckboxes.get(role);
                    if (cb != null) {
                        cb.setSelected(true);
                    }
                    if ((cb = this.clientPermissionCheckboxes.get(role)) == null) continue;
                    cb.setSelected(true);
                }
            }
            this.currentUser = user;
        }
        finally {
            this.settingUser = false;
            this.onChanged(user.isNewUser());
        }
    }

    public boolean isNewUser() {
        return this.currentUser != null && this.currentUser.isNewUser();
    }

    @Override
    public void requestFocus() {
        this.txtUsername.requestFocus();
    }

    private void registerUpDown(JComponent component, boolean up, boolean down) {
        if (up) {
            KeyboardHelper.registerActionOnComponent(component, "cmd up", KeyboardFocusManager.getCurrentKeyboardFocusManager()::focusPreviousComponent);
        }
        if (down) {
            KeyboardHelper.registerActionOnComponent(component, "cmd down", KeyboardFocusManager.getCurrentKeyboardFocusManager()::focusNextComponent);
        }
    }

    public void setLeftComponent(JComponent component) {
        this.registerLeft(component, this.txtUsername, this.txtFullname, this.txtPassword, this.txtPasswordRepeat);
    }

    private void registerLeft(JComponent target, JComponent ... components) {
        Arrays.stream(components).forEach(component -> KeyboardHelper.registerActionOnComponent(component, "cmd left", target::requestFocus));
    }

    @Generated
    public UserEditorPanel(AppColorConfig colorConfig, I18nService i18n) {
        this.colorConfig = colorConfig;
        this.i18n = i18n;
    }

    @Generated
    public boolean isChanged() {
        return this.changed;
    }

    @Generated
    public void setOnSave(Consumer<DmsUser> onSave) {
        this.onSave = onSave;
    }

    @Generated
    public void setOnCancelNew(Consumer<DmsUser> onCancelNew) {
        this.onCancelNew = onCancelNew;
    }

    @Generated
    public void setUserNameList(List<String> userNameList) {
        this.userNameList = userNameList;
    }
}

