/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.schembs.solutions.desktopclient.service.I18nService;
import org.springframework.util.StreamUtils;

public class ReleaseNotesWindow
extends JDialog {
    private final I18nService i18n;

    public static void showReleaseNotesWindow(JFrame parent, I18nService i18n) {
        ReleaseNotesWindow window = new ReleaseNotesWindow(parent, i18n);
        window.createUI();
        window.pack();
        window.center();
        window.setVisible(true);
    }

    public ReleaseNotesWindow(JFrame parent, I18nService i18n) {
        super(parent);
        this.i18n = i18n;
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle(i18n.t("releaseNotes.title", new Object[0]));
    }

    private void createUI() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        JButton okButton = new JButton(this.i18n.t("button.ok", new Object[0]));
        okButton.addActionListener(actionEvent -> this.setVisible(false));
        btnPanel.add(okButton);
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setFocusable(false);
        try {
            editorPane.setText(StreamUtils.copyToString((InputStream)this.getClass().getResourceAsStream("/release-notes.html"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JScrollPane scrollPane = new JScrollPane(editorPane);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.setPreferredSize(new Dimension(400, 400));
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)btnPanel, "South");
        SwingUtilities.invokeLater(() -> scrollPane.getVerticalScrollBar().setValue(0));
    }

    private void center() {
        int x = this.getParent().getX() + (this.getParent().getWidth() - this.getWidth()) / 2;
        int y = this.getParent().getY() + (this.getParent().getHeight() - this.getHeight()) / 2;
        this.setLocation(x, y);
    }
}

