/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import lombok.Generated;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import org.springframework.stereotype.Component;

@Component
public class PasswordChangePanel
extends JPanel
implements DocumentListener {
    private final I18nService i18n;
    private JPasswordField txtOldPassword;
    private JPasswordField txtNewPassword;
    private JPasswordField txtRepeatPassword;
    private boolean valid = false;
    private final List<PasswordChangeListener> passwordChangeListeners = new ArrayList<PasswordChangeListener>();

    @PostConstruct
    public void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new VerticalLayout(2));
        this.add(new JLabel(this.i18n.t("changePassword.password.old", new Object[0])));
        this.txtOldPassword = new JPasswordField();
        this.add(this.txtOldPassword);
        this.add(new JLabel(this.i18n.t("changePassword.password.new", new Object[0])));
        this.txtNewPassword = new JPasswordField();
        this.add(this.txtNewPassword);
        this.add(new JLabel(this.i18n.t("changePassword.password.repeat", new Object[0])));
        this.txtRepeatPassword = new JPasswordField();
        this.add(this.txtRepeatPassword);
        this.txtOldPassword.getDocument().addDocumentListener(this);
        this.txtNewPassword.getDocument().addDocumentListener(this);
        this.txtRepeatPassword.getDocument().addDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkPasswords();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkPasswords();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkPasswords();
    }

    public void clearPasswords() {
        this.txtOldPassword.setText("");
        this.txtNewPassword.setText("");
        this.txtRepeatPassword.setText("");
    }

    public void checkPasswords() {
        this.valid = true;
        this.valid = this.getOldPassword() != null && !this.getOldPassword().isEmpty();
        this.valid = this.valid && this.getNewPassword() != null && this.getNewPassword().length() >= 8;
        this.valid = this.valid && this.getNewPassword().equals(this.getRepeatPassword());
        this.passwordChangeListeners.forEach(passwordChangeListener -> passwordChangeListener.onPasswordChanged(this.valid));
    }

    public String getOldPassword() {
        return this.txtOldPassword.getPassword() != null ? new String(this.txtOldPassword.getPassword()).trim() : null;
    }

    public String getNewPassword() {
        return this.txtNewPassword.getPassword() != null ? new String(this.txtNewPassword.getPassword()).trim() : null;
    }

    private String getRepeatPassword() {
        return this.txtRepeatPassword.getPassword() != null ? new String(this.txtRepeatPassword.getPassword()).trim() : null;
    }

    @Generated
    public PasswordChangePanel(I18nService i18n) {
        this.i18n = i18n;
    }

    @Override
    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public List<PasswordChangeListener> getPasswordChangeListeners() {
        return this.passwordChangeListeners;
    }

    public static interface PasswordChangeListener {
        public void onPasswordChanged(boolean var1);
    }
}

