/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import jakarta.annotation.PostConstruct;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.layout.VerticalLayout;
import net.schembs.solutions.dms.client.config.AppConfig;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoginPanel
extends JPanel {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginPanel.class);
    private static final String PREF_KEY = "loginWindow.";
    private static final String PREF_KEY_USER = "user";
    private static final String PREF_KEY_PASSWORD = "password";
    private static final String PREF_KEY_BACKEND = "loginWindow.backend";
    private static final String PREF_KEY_BACKENDS = "loginWindow.backends.";
    private final AppPreferences appPreferences;
    private final I18nService i18n;
    private final SettingsService<AppSettings> settingsService;
    private final AppConfig appConfig;
    private JTextField txtUsername;
    private JPasswordField txtPassword;
    private JComboBox<Backend> cmbBackend;
    private Backend currentBackend;

    @PostConstruct
    public void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new VerticalLayout(2));
        this.add(new JLabel(this.i18n.t("login.backend", new Object[0])));
        this.cmbBackend = new JComboBox();
        this.add(this.cmbBackend);
        this.add(new JLabel(this.i18n.t("login.user", new Object[0])));
        this.txtUsername = new JTextField();
        this.add(this.txtUsername);
        this.add(new JLabel(this.i18n.t("login.password", new Object[0])));
        this.txtPassword = new JPasswordField();
        this.add(this.txtPassword);
        this.cmbBackend.addActionListener(e -> this.onBackendSelectionChanged());
    }

    public void initUI(String selectBackend) {
        String backendToSelect = selectBackend;
        if (selectBackend == null) {
            backendToSelect = this.appPreferences.get(PREF_KEY_BACKEND);
        }
        this.initBackendCombo(backendToSelect);
        if (selectBackend != null) {
            SwingUtilities.invokeLater(() -> this.txtUsername.requestFocus());
        }
    }

    private void initBackendCombo(String backend) {
        AppSettings settings = this.settingsService.getAppSettings();
        if (settings.getBackends().isEmpty()) {
            settings.setBackends(this.appConfig.getDefaultSettings().getBackends());
        }
        this.cmbBackend.setModel(new DefaultComboBoxModel<Backend>(settings.getBackends().toArray(new Backend[0])));
        Optional<Backend> activeBackend = settings.getBackends().stream().filter(b -> b.getName().equals(backend)).findFirst();
        this.cmbBackend.setSelectedItem(activeBackend.orElseGet(() -> settings.getBackends().getFirst()));
    }

    private void onBackendSelectionChanged() {
        Backend selectedBackend = (Backend)this.cmbBackend.getSelectedItem();
        if (selectedBackend != this.currentBackend) {
            this.loadUserForBackend(selectedBackend != null ? selectedBackend.getName() : null);
            this.currentBackend = selectedBackend;
        }
    }

    private void loadUserForBackend(String backend) {
        if (backend != null) {
            String user = this.appPreferences.get(this.getBackendPrefKey(backend, PREF_KEY_USER));
            String password = this.appPreferences.get(this.getBackendPrefKey(backend, PREF_KEY_PASSWORD));
            this.txtUsername.setText(user);
            this.txtPassword.setText(password);
        } else {
            this.txtUsername.setText("");
            this.txtPassword.setText("");
        }
    }

    private String getBackendPrefKey(String backend, String key) {
        return PREF_KEY_BACKENDS + backend + "." + key;
    }

    public void storeProperties() {
        String backendName = this.currentBackend.getName();
        this.appPreferences.put(PREF_KEY_BACKEND, backendName);
        this.appPreferences.put(this.getBackendPrefKey(backendName, PREF_KEY_USER), this.txtUsername.getText());
        this.appPreferences.put(this.getBackendPrefKey(backendName, PREF_KEY_PASSWORD), this.getPassword());
    }

    public String getUsername() {
        return this.txtUsername.getText();
    }

    public String getPassword() {
        return String.valueOf(this.txtPassword.getPassword());
    }

    public Backend getBackend() {
        return (Backend)this.cmbBackend.getSelectedItem();
    }

    @Generated
    public LoginPanel(AppPreferences appPreferences, I18nService i18n, SettingsService<AppSettings> settingsService, AppConfig appConfig) {
        this.appPreferences = appPreferences;
        this.i18n = i18n;
        this.settingsService = settingsService;
        this.appConfig = appConfig;
    }
}

