/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import jakarta.annotation.PostConstruct;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import lombok.Generated;
import net.schembs.solutions.desktopclient.config.AppPreferences;
import net.schembs.solutions.desktopclient.service.I18nService;
import net.schembs.solutions.desktopclient.service.SettingsService;
import net.schembs.solutions.desktopclient.ui.general.AbstractAboutWindow;
import net.schembs.solutions.desktopclient.ui.general.AbstractAppDelegate;
import net.schembs.solutions.desktopclient.ui.general.AppToolBar;
import net.schembs.solutions.desktopclient.ui.general.OkCancelDialog;
import net.schembs.solutions.desktopclient.ui.layout.AppLayoutService;
import net.schembs.solutions.dms.client.config.AppLayoutConfig;
import net.schembs.solutions.dms.client.controller.AdminController;
import net.schembs.solutions.dms.client.controller.DocumentController;
import net.schembs.solutions.dms.client.controller.ErrorController;
import net.schembs.solutions.dms.client.controller.SettingsController;
import net.schembs.solutions.dms.client.controller.TagController;
import net.schembs.solutions.dms.client.model.Actions;
import net.schembs.solutions.dms.client.model.AppError;
import net.schembs.solutions.dms.client.model.AppSettings;
import net.schembs.solutions.dms.client.model.BackendWithLogin;
import net.schembs.solutions.dms.client.model.Client;
import net.schembs.solutions.dms.client.model.ErrorCode;
import net.schembs.solutions.dms.client.service.BackendProvider;
import net.schembs.solutions.dms.client.service.ClientService;
import net.schembs.solutions.dms.client.service.DmsActionService;
import net.schembs.solutions.dms.client.service.SearchService;
import net.schembs.solutions.dms.client.service.UserService;
import net.schembs.solutions.dms.client.ui.general.AppDelegateListener;
import net.schembs.solutions.dms.client.ui.general.DMSStatusBar;
import net.schembs.solutions.dms.client.ui.general.LoginPanel;
import net.schembs.solutions.dms.client.ui.general.PasswordChangePanel;
import net.schembs.solutions.dms.client.ui.general.ReleaseNotesWindow;
import net.schembs.solutions.dms.client.ui.osspecific.AppMainFrame;
import net.schembs.solutions.dms.security.exception.LoginFailedException;
import net.schembs.solutions.dms.security.exception.TokenRefreshFailedException;
import net.schembs.solutions.dms.security.model.SystemPermission;
import net.schembs.solutions.dms.security.service.AuthService;
import net.schembs.solutions.dms.security.service.SecurityConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Component
public class DmsAppDelegate
extends AbstractAppDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DmsAppDelegate.class);
    private final DmsActionService actionService;
    private final AuthService authService;
    private final DMSStatusBar statusBar;
    private final LoginPanel loginPanel;
    private final ClientService clientService;
    private final I18nService i18n;
    private final TagController tagController;
    private final ErrorController errorController;
    private final SecurityConfigurationService securityConfigurationService;
    private final AppPreferences appPreferences;
    private final DocumentController documentController;
    private final BackendProvider backendProvider;
    private final UserService userService;
    private final SettingsController settingsController;
    private final Map<String, BackendWithLogin> alreadyLoggedIn = new HashMap<String, BackendWithLogin>();
    private final List<AppDelegateListener> listeners = new ArrayList<AppDelegateListener>();
    private final SearchService searchService;
    private final PasswordChangePanel passwordChangePanel;
    private final AdminController adminController;
    private final AppLayoutService appLayoutService;
    private final AppToolBar appToolBar;

    public DmsAppDelegate(SettingsService<AppSettings> settingsService, I18nService i18n, AbstractAboutWindow aboutWindow, DmsActionService actionService, AuthService authService, DMSStatusBar statusBar, LoginPanel loginPanel, ClientService clientService, I18nService i18n1, TagController tagController, ErrorController errorController, SecurityConfigurationService securityConfigurationService, AppPreferences appPreferences, DocumentController documentController, BackendProvider backendProvider, UserService userService, SettingsController settingsController, SearchService searchService, PasswordChangePanel passwordChangePanel, AdminController adminController, AppLayoutService appLayoutService, AppToolBar appToolBar) {
        super(settingsService, i18n, aboutWindow);
        this.actionService = actionService;
        this.authService = authService;
        this.statusBar = statusBar;
        this.loginPanel = loginPanel;
        this.clientService = clientService;
        this.i18n = i18n1;
        this.tagController = tagController;
        this.errorController = errorController;
        this.securityConfigurationService = securityConfigurationService;
        this.appPreferences = appPreferences;
        this.documentController = documentController;
        this.backendProvider = backendProvider;
        this.userService = userService;
        this.settingsController = settingsController;
        this.searchService = searchService;
        this.passwordChangePanel = passwordChangePanel;
        this.adminController = adminController;
        this.appLayoutService = appLayoutService;
        this.appToolBar = appToolBar;
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
        this.authService.getTokenRefreshListeners().add(this::onTokenRefreshFailed);
        this.appPreferences.getShutdownHooks().add(this::onShutdown);
        this.errorController.getErrorReceivedListeners().add(this::onErrorReceived);
    }

    @Override
    protected void configureActions() {
        this.actionService.getAction(Actions.about).setActionListener(e -> this.showAboutWindow());
        this.actionService.getAction(Actions.releaseNotes).setActionListener(e -> this.showReleaseNotes());
        this.actionService.getAction(Actions.quit).setActionListener(e -> this.onPrepareClose());
        this.actionService.getAction(Actions.changeBackend).setActionListener(this::onChangeBackend);
        this.actionService.getAction(Actions.login).setActionListener(e -> this.onPrepareLogin(null));
        this.actionService.getAction(Actions.logout).setActionListener(e -> this.onLogout());
        this.actionService.getAction(Actions.changePassword).setActionListener(e -> this.onChangePassword());
        this.actionService.getAction(Actions.showSettings).setActionListener(actionEvent -> this.showPreferences());
        this.actionService.getAction(Actions.showAdmin).setActionListener(actionEvent -> this.showAdmin());
    }

    public void onPrepareLogin(String backend) {
        if (!this.authService.isAuthenticated()) {
            this.actionService.setLoggedIn(false);
            this.loginPanel.initUI(backend);
            OkCancelDialog dialog = new OkCancelDialog((Window)this.getMainFrame().getFrame(), this.i18n);
            dialog.setTitle(this.i18n.t("login.title", new Object[0]));
            dialog.createUI();
            dialog.getContentPane().add((java.awt.Component)this.loginPanel, "Center");
            dialog.pack();
            dialog.center();
            dialog.setVisible(true);
            if (!dialog.isCanceled()) {
                this.backendProvider.setCurrentBackend(this.loginPanel.getBackend());
                this.securityConfigurationService.init();
                this.onBackendConfigured();
                this.login(this.loginPanel.getUsername(), this.loginPanel.getPassword());
                if (this.authService.isAuthenticated()) {
                    this.loginPanel.storeProperties();
                    this.alreadyLoggedIn.put(this.loginPanel.getBackend().getName(), BackendWithLogin.builder().backend(this.loginPanel.getBackend()).username(this.loginPanel.getUsername()).password(this.loginPanel.getPassword()).build());
                }
            }
        }
    }

    public void onPrepareReLogin(String backend) {
        BackendWithLogin backendWithLogin = this.alreadyLoggedIn.get(backend);
        if (backendWithLogin != null) {
            this.backendProvider.setCurrentBackend(backendWithLogin.getBackend());
            this.securityConfigurationService.init();
            this.onBackendConfigured();
            this.login(backendWithLogin.getUsername(), backendWithLogin.getPassword());
            if (!this.authService.isAuthenticated()) {
                this.onPrepareLogin(backend);
            }
        } else {
            this.onPrepareLogin(backend);
        }
    }

    private void onBackendConfigured() {
        this.listeners.forEach(AppDelegateListener::onBackendConfigured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void login(String username, String password) {
        try {
            this.authService.login(username, password);
            this.onLoggedIn();
        }
        catch (LoginFailedException e) {
            this.errorController.handleError(ErrorCode.loginFailed, e, new Object[0]);
        }
        finally {
            this.updateStatusBar();
        }
    }

    private void onLoggedIn() {
        this.actionService.setLoggedIn(true);
        this.listeners.forEach(AppDelegateListener::onLoggedIn);
        this.clientService.loadClientDataForUser(this.authService.getUser());
        this.tagController.initTreeWithUserData();
        this.documentController.loadDescriptions();
    }

    private void onLogout() {
        this.authService.logout();
        this.searchService.removeAllResults();
        this.clientService.clearClient();
        this.actionService.setLoggedIn(false);
        this.listeners.forEach(AppDelegateListener::onLoggedOut);
        this.updateStatusBar();
        this.tagController.initTreeWithUserData();
        this.documentController.clear();
    }

    private void updateStatusBar() {
        Client client = this.clientService.getClient();
        this.statusBar.setClient(client != null ? client.getTitle() : "");
        this.updateStatusBarUsername();
    }

    private void updateStatusBarUsername() {
        String username = this.authService.getUser() != null ? this.authService.getUser().getName() : "";
        this.statusBar.setUsername(username);
    }

    private void onTokenRefreshFailed(TokenRefreshFailedException tokenRefreshFailedException) {
        this.errorController.handleError(ErrorCode.tokenRefreshFailed, (Throwable)tokenRefreshFailedException, new Object[0]);
        this.onLogout();
    }

    @Override
    public void initUI() {
        this.appLayoutService.selectLayout(AppLayoutConfig.Layouts.document.name(), this.getMainFrame().getMainPanel(), this.getMainFrame().getFrame().getSize());
        AppToolBar appToolBar = this.appToolBar;
        if (appToolBar instanceof AppDelegateListener) {
            AppDelegateListener appDelegateListener = (AppDelegateListener)((Object)appToolBar);
            this.listeners.add(appDelegateListener);
        }
        this.listeners.add((AppMainFrame)this.getMainFrame());
    }

    @Override
    public void showPreferences() {
        this.processIfMainFrameInFocus(() -> this.settingsController.showSettings(this.getMainFrame().getFrame()));
    }

    private void showAdmin() {
        if (this.authService.isAuthenticated() && this.authService.getUser().getSystemPermissions().contains(SystemPermission.admin)) {
            this.processIfMainFrameInFocus(() -> this.adminController.showAdmin(this.getMainFrame().getFrame()));
        }
    }

    private void onShutdown(AppPreferences appPreferences) {
        log.info("Shutting down...");
        this.onLogout();
    }

    private void onErrorReceived(AppError appError) {
        this.errorController.showError(this.getMainFrame().getFrame(), appError);
    }

    public void showReleaseNotes() {
        this.processIfMainFrameInFocus(() -> ReleaseNotesWindow.showReleaseNotesWindow(this.getMainFrame().getFrame(), this.i18n));
    }

    private void onChangeBackend(ActionEvent e) {
        this.onLogout();
        this.onPrepareReLogin(e.getActionCommand());
    }

    private void onChangePassword() {
        OkCancelDialog dialog = new OkCancelDialog((Window)this.getMainFrame().getFrame(), this.i18n);
        dialog.setTitle(this.i18n.t("changePassword.title", new Object[0]));
        dialog.createUI();
        dialog.getContentPane().add((java.awt.Component)this.passwordChangePanel, "Center");
        this.passwordChangePanel.clearPasswords();
        this.passwordChangePanel.getPasswordChangeListeners().clear();
        this.passwordChangePanel.getPasswordChangeListeners().add(dialog::setOkButtonEnabled);
        this.passwordChangePanel.checkPasswords();
        dialog.pack();
        dialog.setVisible(true);
        if (!dialog.isCanceled()) {
            try {
                this.userService.changePassword(this.authService.getUser().getName(), this.passwordChangePanel.getOldPassword(), this.passwordChangePanel.getNewPassword());
                JOptionPane.showMessageDialog(this.getMainFrame().getFrame(), this.i18n.t("changePassword.password.changed", new Object[0]));
            }
            catch (HttpClientErrorException.Unauthorized e) {
                this.errorController.handleError(ErrorCode.passwordChangeWrongPassword, e, new Object[0]);
            }
            catch (Exception e) {
                this.errorController.handleError(ErrorCode.passwordChangeFailed, e, new Object[0]);
            }
        }
    }

    @Generated
    public List<AppDelegateListener> getListeners() {
        return this.listeners;
    }
}

