/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import jakarta.annotation.PostConstruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lombok.Generated;
import net.schembs.solutions.desktopclient.ui.UIUtils;
import net.schembs.solutions.dms.client.config.AppColorConfig;
import net.schembs.solutions.dms.client.config.AppConfig;
import net.schembs.solutions.dms.client.controller.ErrorController;
import net.schembs.solutions.dms.client.model.AppError;
import net.schembs.solutions.dms.client.ui.general.AboutWindow;
import org.springframework.boot.info.BuildProperties;
import org.springframework.boot.info.GitProperties;

@org.springframework.stereotype.Component
public class DMSStatusBar
extends JPanel {
    private final AppConfig appConfig;
    private final AppColorConfig colorConfig;
    private final ErrorController errorController;
    private final UIUtils uiUtils;
    private final AboutWindow aboutWindow;
    private final BuildProperties buildProperties;
    private final GitProperties gitProperties;
    private JLabel userLabel;
    private JLabel clientLabel;
    private JLabel errorLabel;

    @PostConstruct
    public void createUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(this.colorConfig.getBarBackground());
        this.setBorder(BorderFactory.createMatteBorder(2, 0, 0, 0, this.colorConfig.getSeparatorColor()));
        JPanel leftPanel = new JPanel(new FlowLayout(0, 5, 0));
        leftPanel.setBackground(Color.GREEN);
        leftPanel.setOpaque(false);
        leftPanel.add(Box.createHorizontalStrut(this.getBarInsets().left));
        leftPanel.add(new JLabel(this.appConfig.getName()));
        this.clientLabel = new JLabel("");
        leftPanel.add(this.clientLabel);
        this.add((Component)leftPanel, "West");
        JPanel rightPanel = new JPanel(new FlowLayout(2, 5, 0));
        rightPanel.setBackground(Color.red);
        rightPanel.setOpaque(false);
        this.userLabel = new JLabel("");
        rightPanel.add(this.userLabel);
        this.errorLabel = new JLabel();
        rightPanel.add(this.errorLabel);
        rightPanel.add(new JLabel(this.getFullVersion()));
        rightPanel.add(Box.createHorizontalStrut(this.getBarInsets().right));
        this.add((Component)rightPanel, "East");
        this.errorLabel.setVisible(false);
        this.errorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DMSStatusBar.this.onErrorLabelClicked();
            }
        });
        this.errorController.getErrorReceivedListeners().add(this::onErrorReceived);
    }

    private String getFullVersion() {
        return this.buildProperties.getName() + " " + this.buildProperties.getVersion() + " [" + this.gitProperties.getShortCommitId() + "]";
    }

    private Insets getBarInsets() {
        return new Insets(0, 10, 0, 10);
    }

    public void setUsername(String username) {
        this.userLabel.setText(username);
    }

    public void setClient(String client) {
        this.clientLabel.setText((String)(client != null && !client.isEmpty() ? " - " + client : ""));
    }

    private void onErrorReceived(AppError error) {
        this.errorLabel.setIcon(this.uiUtils.getImageIcon("error-16.png"));
        this.errorLabel.setVisible(true);
    }

    private void onErrorLabelClicked() {
        this.errorController.showErrors(this.uiUtils.findMainFrame(this));
    }

    @Generated
    public DMSStatusBar(AppConfig appConfig, AppColorConfig colorConfig, ErrorController errorController, UIUtils uiUtils, AboutWindow aboutWindow, BuildProperties buildProperties, GitProperties gitProperties) {
        this.appConfig = appConfig;
        this.colorConfig = colorConfig;
        this.errorController = errorController;
        this.uiUtils = uiUtils;
        this.aboutWindow = aboutWindow;
        this.buildProperties = buildProperties;
        this.gitProperties = gitProperties;
    }
}

