/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import lombok.Generated;

public class ChangeDetector
implements DocumentListener {
    private boolean changed;
    private final List<Document> attachedDocuments = new ArrayList<Document>();
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setChanged();
    }

    public void setChanged() {
        this.changed = true;
        this.changeListeners.forEach(l -> l.onChanged(this.changed));
    }

    public void applyTo(JTextField textField) {
        textField.getDocument().addDocumentListener(this);
        this.attachedDocuments.add(textField.getDocument());
    }

    public void applyTo(JCheckBox checkBox) {
        checkBox.addActionListener(e -> this.setChanged());
    }

    public void applyTo(JComboBox<?> comboBox) {
        comboBox.addActionListener(e -> this.setChanged());
    }

    @Generated
    public List<ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }

    public static interface ChangeListener {
        public void onChanged(boolean var1);
    }
}

