/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.ui.general;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JTextField;
import lombok.Generated;

public class AutoCompleteTextField
extends JTextField {
    private List<String> completions;
    private String lastMatch;

    public AutoCompleteTextField() {
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                AutoCompleteTextField.this.onKeyReleased(e);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: 
                    case 38: 
                    case 40: {
                        e.consume();
                    }
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (AutoCompleteTextField.this.getCaretPosition() == AutoCompleteTextField.this.getDocument().getLength()) break;
                    }
                    case 38: 
                    case 40: {
                        e.consume();
                    }
                }
            }
        });
    }

    public void onKeyReleased(KeyEvent e) {
        String match;
        int lastMatchIndex;
        int caret = this.getCaretPosition();
        String lowerText = this.getText().substring(0, caret).toLowerCase();
        List<String> matches = this.completions.stream().filter(s -> s.toLowerCase().startsWith(lowerText)).toList();
        int n = lastMatchIndex = this.lastMatch != null ? matches.indexOf(this.lastMatch) : -1;
        this.lastMatch = match = !matches.isEmpty() && lastMatchIndex < matches.size() - 1 && lastMatchIndex >= 0 ? matches.get(lastMatchIndex) : (!matches.isEmpty() ? matches.getFirst() : "");
        if (!matches.isEmpty()) {
            if (e.getKeyCode() == 8) {
                --caret;
            }
            if (e.getKeyCode() == 127) {
                this.setText(this.getText().substring(0, caret));
            } else {
                if (e.getKeyCode() == 40) {
                    e.consume();
                    if (lastMatchIndex < matches.size() - 1) {
                        match = matches.get(lastMatchIndex + 1);
                    }
                } else if (e.getKeyCode() == 38) {
                    e.consume();
                    if (lastMatchIndex > 0) {
                        match = matches.get(lastMatchIndex - 1);
                    }
                }
                this.setText(match);
                this.lastMatch = match;
                if (e.getKeyCode() == 10) {
                    int idx;
                    this.setCaretPosition(match.length());
                    if (idx > -1) {
                        for (idx = match.indexOf(32, caret); idx < match.length() - 1 && match.charAt(idx) == ' '; ++idx) {
                        }
                        this.moveCaretPosition(idx);
                    }
                } else {
                    this.setCaretPosition(match.length());
                    if (caret > -1) {
                        this.moveCaretPosition(caret);
                    }
                }
            }
        }
    }

    @Generated
    public void setCompletions(List<String> completions) {
        this.completions = completions;
    }
}

