/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import lombok.Generated;
import net.schembs.solutions.dms.security.service.AuthService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.client.HttpClientErrorException;

@Aspect
@Component
public class SecurityHelperAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityHelperAspect.class);
    private final AuthService authService;

    @Around(value="execution(* net.schembs.solutions.dms.client.service.DocumentStoreService.*(..))")
    public Object tryReLoginAndExecuteAgainIfTokenSeemsToBeExpired(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            return joinPoint.proceed();
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                this.authService.reLogin();
                return joinPoint.proceed();
            }
            throw e;
        }
    }

    @Generated
    public SecurityHelperAspect(AuthService authService) {
        this.authService = authService;
    }
}

