/*
 * Decompiled with CFR 0.152.
 */
package net.schembs.solutions.dms.client.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.schembs.solutions.dms.client.document.api.model.DocumentSearchResult;
import net.schembs.solutions.dms.client.exception.DocumentSearchFailedException;
import net.schembs.solutions.dms.client.exception.DocumentSearchResultEmptyException;
import net.schembs.solutions.dms.client.model.DmsDocument;
import net.schembs.solutions.dms.client.model.DocumentStatus;
import net.schembs.solutions.dms.client.model.SearchResultType;
import net.schembs.solutions.dms.client.service.DocumentStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchService.class);
    private final DocumentStoreService documentStoreService;
    private final Set<String> failed = new HashSet<String>();

    @Async
    public CompletableFuture<List<DmsDocument>> findDocumentsWithText(String text) {
        String idString = this.getIdString(text);
        if (this.failed.contains(idString)) {
            return CompletableFuture.completedFuture(new ArrayList());
        }
        try {
            log.info("Searching for documents with ... {}", (Object)text);
            List<DmsDocument> documents = Arrays.stream(this.documentStoreService.findDocumentsWithText(text)).map(this::mapDocumentSearchResultToDMSDocument).toList();
            log.info("Documents found: {} for {}.", (Object)documents.size(), (Object)text);
            if (documents.isEmpty()) {
                throw new DocumentSearchResultEmptyException(text);
            }
            return CompletableFuture.completedFuture(documents);
        }
        catch (Exception e) {
            this.failed.add(idString);
            return CompletableFuture.failedFuture(new DocumentSearchFailedException(e, text));
        }
    }

    private String getIdString(String text) {
        return text.trim().toLowerCase();
    }

    public DmsDocument mapDocumentSearchResultToDMSDocument(DocumentSearchResult searchResult) {
        return DmsDocument.builder().id(searchResult.getId()).name(searchResult.getName()).description(searchResult.getDescription()).status(DocumentStatus.valueOf(searchResult.getStatus())).storageId(UUID.randomUUID().toString()).changeUser(searchResult.getChangeUser()).changeDate(searchResult.getChangeDate()).createDate(searchResult.getCreateDate()).createUser(searchResult.getCreateUser()).owner(searchResult.getOwner()).assignee(searchResult.getAssignee()).documentDate(searchResult.getDocumentDate()).result(searchResult.getResult()).resultType(this.mapResultType(searchResult.getResultType())).build();
    }

    private SearchResultType mapResultType(Integer searchResultType) {
        if (searchResultType != null) {
            return switch (searchResultType) {
                case 0 -> SearchResultType.id;
                case 1 -> SearchResultType.descriptionContainsFull;
                case 2 -> SearchResultType.descriptionContainsParts;
                case 3 -> SearchResultType.contentContains;
                default -> SearchResultType.unknown;
            };
        }
        return SearchResultType.unknown;
    }

    public void removeResult(String name) {
        this.failed.remove(this.getIdString(name));
    }

    public void removeAllResults() {
        this.failed.clear();
    }

    @Generated
    public SearchService(DocumentStoreService documentStoreService) {
        this.documentStoreService = documentStoreService;
    }
}

